/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.building.debugging.TemplateDebugger;
import grounding.debugging.GroundingDebugger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import networks.computation.training.debugging.TrainingDebugger;
import networks.structure.building.debugging.NeuralDebugger;
import pipelines.Pipeline;
import pipelines.building.End2endTrainigBuilder;
import pipelines.building.LearningSchemeBuilder;
import settings.Settings;
import settings.Sources;

public abstract class AbstractPipelineBuilder<S, T> {
    private static final Logger LOG = Logger.getLogger(AbstractPipelineBuilder.class.getName());
    public Settings settings;

    public AbstractPipelineBuilder(Settings settings) {
        this.settings = settings;
    }

    public abstract Pipeline<S, T> buildPipeline();

    public List<Pipeline<S, T>> buildPipelines(int count) {
        ArrayList<Pipeline<S, T>> pipelines = new ArrayList<Pipeline<S, T>>(count);
        for (int i = 0; i < count; ++i) {
            Pipeline<S, T> ppln = this.buildPipeline();
            ppln.ID = ppln.ID + i;
            pipelines.add(ppln);
        }
        return pipelines;
    }

    public static AbstractPipelineBuilder<Sources, ?> getBuilder(Sources sources, Settings settings) {
        if (settings.mainMode == Settings.MainMode.COMPLETE) {
            return new LearningSchemeBuilder(settings, sources);
        }
        if (settings.mainMode == Settings.MainMode.DEBUGGING) {
            if (settings.debugTemplateTraining || settings.debugSampleTraining) {
                return new TrainingDebugger(sources, settings);
            }
            if (settings.debugNeuralization) {
                return new NeuralDebugger(sources, settings);
            }
            if (settings.debugGrounding) {
                return new GroundingDebugger(sources, settings);
            }
            if (settings.debugTemplate) {
                return new TemplateDebugger(sources, settings);
            }
        } else if (settings.mainMode == Settings.MainMode.NEURALIZATION) {
            return new End2endTrainigBuilder.End2endNNBuilder(new End2endTrainigBuilder(settings, sources));
        }
        LOG.severe("Unknown pipeline mainMode!");
        throw new UnsupportedOperationException();
    }
}

