/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.template.Template;
import java.util.logging.Logger;
import learning.crossvalidation.TrainTestResults;
import networks.computation.evaluation.results.Progress;
import networks.computation.evaluation.results.Results;
import networks.computation.training.NeuralModel;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.building.CrossvalidationBuilder;
import pipelines.building.TestingBuilder;
import pipelines.building.TrainTestBuilder;
import pipelines.building.TrainingBuilder;
import pipelines.pipes.generic.SecondFromPairPipe;
import pipelines.pipes.specific.ResultsFromProgressPipe;
import settings.Settings;
import settings.Sources;
import utils.generic.Pair;

public class LearningSchemeBuilder
extends AbstractPipelineBuilder<Sources, Results> {
    private static final Logger LOG = Logger.getLogger(LearningSchemeBuilder.class.getName());
    private Sources sources;

    public LearningSchemeBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Results> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, Results> buildPipeline(Sources sources) {
        Pipeline<Sources, Results> pipeline = new Pipeline<Sources, Results>("LearningSchemePipeline", this);
        if (sources.crossvalidation) {
            LOG.info("Learning scheme inferred as : crossvalidation.");
            CrossvalidationBuilder crossvalidationSchemeBuilder = new CrossvalidationBuilder(this.settings, sources);
            Pipeline<Sources, TrainTestResults> crossvalPipeline = pipeline.registerStart(crossvalidationSchemeBuilder.buildPipeline());
            crossvalPipeline.connectAfter(pipeline.registerEnd(this.getTestResultsPipe()));
        } else if (sources.trainTest) {
            LOG.info("Learning scheme inferred as : train-test.");
            TrainTestBuilder trainTestBuilder = new TrainTestBuilder(this.settings, sources);
            Pipeline<Sources, TrainTestResults> trainTestPipeline = pipeline.registerStart(trainTestBuilder.buildPipeline());
            trainTestPipeline.connectAfter(pipeline.registerEnd(this.getTestResultsPipe()));
        } else if (sources.trainOnly) {
            LOG.info("Learning scheme inferred as : pure training.");
            Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.registerStart(new TrainingBuilder(this.settings, sources).buildPipeline());
            SecondFromPairPipe secondFromPairPipe = pipeline.register(new SecondFromPairPipe());
            trainingPipeline.connectAfter(secondFromPairPipe);
            ResultsFromProgressPipe resultsFromProgressPipe = pipeline.registerEnd(new ResultsFromProgressPipe());
            secondFromPairPipe.connectAfter(resultsFromProgressPipe);
        } else if (sources.testOnly) {
            LOG.info("Learning scheme inferred as : pure testing.");
            Pipeline<Sources, Results> pipeline2 = pipeline.registerEnd(pipeline.registerStart(new TestingBuilder(this.settings, sources).buildPipeline()));
        } else {
            LOG.severe("Invalid learning mode setting.");
        }
        return pipeline;
    }

    Pipe<TrainTestResults, Results> getTestResultsPipe() {
        return new Pipe<TrainTestResults, Results>("GetTestResultsPipe"){

            @Override
            public Results apply(TrainTestResults trainTestResults) {
                return trainTestResults.testing;
            }
        };
    }
}

