/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.building.ExamplesBuilder;
import constructs.building.QueriesBuilder;
import constructs.example.LiftedExample;
import constructs.example.LogicSample;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import learning.Query;
import learning.crossvalidation.splitting.StratifiedSplitter;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import settings.Settings;
import settings.Source;

public class SamplesProcessingBuilder
extends AbstractPipelineBuilder<Source, Stream<LogicSample>> {
    private static final Logger LOG = Logger.getLogger(SamplesProcessingBuilder.class.getName());
    private Source source;

    public SamplesProcessingBuilder(Settings settings, Source source) {
        super(settings);
        this.source = source;
    }

    @Override
    public Pipeline<Source, Stream<LogicSample>> buildPipeline() {
        return this.buildPipeline(this.source);
    }

    public Pipeline<Source, Stream<LogicSample>> buildPipeline(Source source) {
        Pipeline<Source, Stream<LogicSample>> samplesProcessingPipeline = new Pipeline<Source, Stream<LogicSample>>("SamplesProcessingPipeline", this);
        Pipe<Source, Stream<LogicSample>> sourcesSamplesPipe = samplesProcessingPipeline.registerStart(this.extractSamplesPipe(source));
        Pipe<Stream<LogicSample>, Stream<LogicSample>> samplesPostprocessPipe = samplesProcessingPipeline.registerEnd(this.postprocessSamplesPipe());
        sourcesSamplesPipe.connectAfter(samplesPostprocessPipe);
        return samplesProcessingPipeline;
    }

    @Deprecated
    public Pipe<Source, Stream<LiftedExample>> extractExamples(Source source) {
        return null;
    }

    @Deprecated
    public Pipe<Source, Stream<Query>> extractQueries(Source source) {
        return null;
    }

    public Pipe<Source, Stream<LogicSample>> extractSamplesPipe(Source source) {
        if (source.ExamplesReader == null && source.QueriesReader == null) {
            LOG.severe("No sources found to assemble Samples at construction");
        }
        Pipe<Source, Stream<LogicSample>> sampleExtractionPipe = null;
        if (source.QueriesSeparate && source.ExamplesSeparate) {
            sampleExtractionPipe = new Pipe<Source, Stream<LogicSample>>("QueriesWithExamplesPipe", this.settings){

                @Override
                public Stream<LogicSample> apply(Source source) {
                    ExamplesBuilder examplesBuilder = new ExamplesBuilder(this.settings);
                    Stream<LogicSample> examples = examplesBuilder.buildSamplesFrom(examplesBuilder.parseTreeFrom(source.ExamplesReader));
                    QueriesBuilder queriesBuilder = new QueriesBuilder(this.settings);
                    queriesBuilder.setFactoriesFrom(examplesBuilder);
                    Stream<LogicSample> queries = queriesBuilder.buildSamplesFrom(queriesBuilder.parseTreeFrom(source.QueriesReader));
                    return queriesBuilder.merge2streams(queries, examples);
                }
            };
        } else if (!source.QueriesSeparate && source.QueriesProvided && source.ExamplesSeparate) {
            sampleExtractionPipe = new Pipe<Source, Stream<LogicSample>>("QueriesWithinExamplesPipe", this.settings){

                @Override
                public Stream<LogicSample> apply(Source source) {
                    ExamplesBuilder examplesBuilder = new ExamplesBuilder(this.settings);
                    Stream<LogicSample> labeledExamples = examplesBuilder.buildSamplesFrom(examplesBuilder.parseTreeFrom(source.ExamplesReader));
                    return labeledExamples;
                }
            };
        } else if (!source.QueriesProvided && source.ExamplesSeparate) {
            sampleExtractionPipe = new Pipe<Source, Stream<LogicSample>>("UnsupervisedExamplesPipe", this.settings){

                @Override
                public Stream<LogicSample> apply(Source source) {
                    ExamplesBuilder examplesBuilder = new ExamplesBuilder(this.settings);
                    Stream<LogicSample> unlabeledExamples = examplesBuilder.buildSamplesFrom(examplesBuilder.parseTreeFrom(source.ExamplesReader));
                    return unlabeledExamples;
                }
            };
        } else if (source.QueriesSeparate && !source.ExamplesProvided) {
            sampleExtractionPipe = new Pipe<Source, Stream<LogicSample>>("QueriesOnlyPipe", this.settings){

                @Override
                public Stream<LogicSample> apply(Source source) {
                    QueriesBuilder queriesBuilder = new QueriesBuilder(this.settings);
                    return queriesBuilder.buildSamplesFrom(queriesBuilder.parseTreeFrom(source.QueriesReader));
                }
            };
        } else {
            LOG.severe("No sources found to assemble Samples at pipe construction");
            return null;
        }
        return sampleExtractionPipe;
    }

    public Pipe<Stream<LogicSample>, Stream<LogicSample>> postprocessSamplesPipe() {
        Pipe<Stream<LogicSample>, Stream<LogicSample>> postProcessPipe = new Pipe<Stream<LogicSample>, Stream<LogicSample>>("PostprocessSamplesPipe", this.settings){

            @Override
            public Stream<LogicSample> apply(Stream<LogicSample> logicSampleStream) {
                if (this.settings.appLimitSamples > 0) {
                    LOG.warning("Limiting the learning samples to the first: " + this.settings.appLimitSamples);
                    if (this.settings.stratification) {
                        LOG.warning("Stratified subset requested, will need to consume the stream of LogicSamples first...");
                        List collect = logicSampleStream.collect(Collectors.toList());
                        Collections.shuffle(collect, this.settings.random);
                        StratifiedSplitter stratifiedSplitter = new StratifiedSplitter(this.settings);
                        List stratifiedSubset = stratifiedSplitter.getStratifiedSubset(collect, this.settings.appLimitSamples);
                        LOG.info("Limited to exactly " + stratifiedSubset.size() + " samples (may be slightly different from the requested " + this.settings.appLimitSamples + " due to class balancing)");
                        logicSampleStream = stratifiedSubset.stream();
                    } else {
                        logicSampleStream = logicSampleStream.limit(this.settings.appLimitSamples);
                    }
                }
                return logicSampleStream;
            }
        };
        return postProcessPipe;
    }
}

