/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.example.LogicSample;
import constructs.template.Template;
import grounding.GroundingSample;
import java.util.logging.Logger;
import java.util.stream.Stream;
import networks.computation.evaluation.results.Results;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import networks.structure.building.Neuralizer;
import pipelines.Branch;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.building.GroundingBuilder;
import pipelines.building.NeuralNetsBuilder;
import pipelines.building.SamplesProcessingBuilder;
import pipelines.building.TemplateProcessingBuilder;
import pipelines.pipes.generic.DuplicateBranch;
import pipelines.pipes.generic.PairMerge;
import pipelines.pipes.specific.NeuralEvaluationPipe;
import pipelines.pipes.specific.TemplateToNeuralPipe;
import settings.Settings;
import settings.Source;
import settings.Sources;
import utils.generic.Pair;

public class TestingBuilder
extends AbstractPipelineBuilder<Sources, Results> {
    private static final Logger LOG = Logger.getLogger(TestingBuilder.class.getName());
    Sources sources;

    public TestingBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
    }

    @Override
    public Pipeline<Sources, Results> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, Results> buildPipeline(Sources sources) {
        Pipeline<Sources, Results> pipeline = new Pipeline<Sources, Results>("TestingPipeline", this);
        DuplicateBranch duplicateSources = pipeline.registerStart(new DuplicateBranch());
        1 getTestSourcePipe = pipeline.register(new Pipe<Sources, Source>("getTestSourcePipe"){

            @Override
            public Source apply(Sources sources) {
                return sources.test;
            }
        });
        Pipeline<Source, Stream<LogicSample>> testSampleStream = pipeline.register(new SamplesProcessingBuilder(this.settings, sources.test).buildPipeline());
        Pipeline<Sources, Template> templatePipeline = pipeline.register(new TemplateProcessingBuilder(this.settings, sources).buildPipeline());
        DuplicateBranch duplicateTemplate = pipeline.register(new DuplicateBranch());
        TemplateToNeuralPipe templateToNeuralPipe = pipeline.register(new TemplateToNeuralPipe(this.settings));
        PairMerge pairMerge = pipeline.register(new PairMerge());
        TestingBuilder testingBuilder = new TestingBuilder(this.settings, sources);
        testingBuilder.getClass();
        LogicTestingBuilder testingBuilder2 = testingBuilder.new LogicTestingBuilder(this.settings);
        Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> logicTestingPipeline = pipeline.registerEnd(testingBuilder2.buildPipeline());
        PairMerge modelMerge = pipeline.register(new PairMerge());
        duplicateSources.connectAfterL(getTestSourcePipe);
        duplicateSources.connectAfterR(templatePipeline);
        getTestSourcePipe.connectAfter(testSampleStream);
        templatePipeline.connectAfter(duplicateTemplate);
        duplicateTemplate.connectAfterL(templateToNeuralPipe);
        modelMerge.connectBeforeL(duplicateTemplate.output2);
        modelMerge.connectBeforeR(templateToNeuralPipe);
        pairMerge.connectBeforeL(modelMerge);
        pairMerge.connectBeforeR(testSampleStream);
        pairMerge.connectAfter(logicTestingPipeline);
        return pipeline;
    }

    public class NeuralTestingBuilder
    extends AbstractPipelineBuilder<Pair<NeuralModel, Stream<NeuralSample>>, Results> {
        public NeuralTestingBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> buildPipeline() {
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> pipeline = new Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results>("NeuralTestingPipeline", this);
            NeuralEvaluationPipe neuralEvaluationPipe = pipeline.registerEnd(pipeline.registerStart(new NeuralEvaluationPipe(this.settings)));
            return pipeline;
        }
    }

    public class LogicTestingBuilder
    extends AbstractPipelineBuilder<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> {
        Pipeline<Pair<Template, Stream<LogicSample>>, Stream<GroundingSample>> groundingPipeline;
        Pipeline<Stream<GroundingSample>, Stream<NeuralSample>> neuralizationPipeline;
        Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> neuralTestingPipeline;

        public LogicTestingBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> buildPipeline() {
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> pipeline = new Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results>("LogicTestingPipeline", this);
            if (this.groundingPipeline == null) {
                GroundingBuilder groundingBuilder = new GroundingBuilder(this.settings);
                this.groundingPipeline = pipeline.register(groundingBuilder.buildPipeline());
                NeuralNetsBuilder neuralNetsBuilder = new NeuralNetsBuilder(this.settings, new Neuralizer(this.settings, groundingBuilder.grounder.weightFactory));
                this.neuralizationPipeline = pipeline.register(neuralNetsBuilder.buildPipeline());
            }
            if (this.neuralTestingPipeline == null) {
                NeuralTestingBuilder neuralTestingBuilder = new NeuralTestingBuilder(this.settings);
                this.neuralTestingPipeline = pipeline.registerEnd(neuralTestingBuilder.buildPipeline());
            }
            1 modelSplitBranch = pipeline.registerStart(new Branch<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Pair<Template, Stream<LogicSample>>, NeuralModel>("ModelSplitBranch"){

                @Override
                protected Pair<Pair<Template, Stream<LogicSample>>, NeuralModel> branch(Pair<Pair<Template, NeuralModel>, Stream<LogicSample>> input) {
                    return new Pair<Pair<Template, Stream<LogicSample>>, NeuralModel>(new Pair(((Pair)input.r).r, input.s), (NeuralModel)((Pair)input.r).s);
                }
            });
            modelSplitBranch.connectAfterL(this.groundingPipeline);
            this.groundingPipeline.connectAfter(this.neuralizationPipeline);
            PairMerge testMerge = pipeline.register(new PairMerge());
            testMerge.connectBeforeL(modelSplitBranch.output2);
            testMerge.connectBeforeR(this.neuralizationPipeline);
            testMerge.connectAfter(this.neuralTestingPipeline);
            return pipeline;
        }
    }
}

