/*
 * Decompiled with CFR 0.152.
 */
package pipelines.building;

import constructs.example.LogicSample;
import constructs.template.Template;
import java.util.logging.Logger;
import java.util.stream.Stream;
import learning.crossvalidation.TrainTestResults;
import networks.computation.evaluation.results.Progress;
import networks.computation.evaluation.results.Results;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import pipelines.Merge;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.building.AbstractPipelineBuilder;
import pipelines.building.SamplesProcessingBuilder;
import pipelines.building.TestingBuilder;
import pipelines.building.TrainingBuilder;
import pipelines.pipes.generic.DuplicateBranch;
import pipelines.pipes.generic.PairBranch;
import pipelines.pipes.generic.PairMerge;
import settings.Settings;
import settings.Source;
import settings.Sources;
import utils.generic.Pair;

public class TrainTestBuilder
extends AbstractPipelineBuilder<Sources, TrainTestResults> {
    private static final Logger LOG = Logger.getLogger(TrainTestBuilder.class.getName());
    private final Sources sources;
    TrainingBuilder trainingBuilder;
    TestingBuilder testingBuilder;
    Merge<Progress, Results, TrainTestResults> resultsMerge;

    public TrainTestBuilder(Settings settings, Sources sources) {
        super(settings);
        this.sources = sources;
        this.trainingBuilder = new TrainingBuilder(settings, sources);
        this.testingBuilder = new TestingBuilder(settings, sources);
        this.resultsMerge = new Merge<Progress, Results, TrainTestResults>("TrainTestResultsMerge"){

            @Override
            protected TrainTestResults merge(Progress train, Results test) {
                return new TrainTestResults(train, test);
            }
        };
    }

    @Override
    public Pipeline<Sources, TrainTestResults> buildPipeline() {
        return this.buildPipeline(this.sources);
    }

    public Pipeline<Sources, TrainTestResults> buildPipeline(Sources sources) {
        Pipeline<Sources, TrainTestResults> pipeline = new Pipeline<Sources, TrainTestResults>("TrainTestPipeline", this);
        DuplicateBranch duplicateSources = pipeline.registerStart(new DuplicateBranch());
        2 testExtrPipe = pipeline.register(new Pipe<Sources, Source>("TestExtractionPipe"){

            @Override
            public Source apply(Sources sources) {
                return sources.test;
            }
        });
        Pipeline<Sources, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(this.trainingBuilder.buildPipeline());
        PairBranch pairBranch1 = pipeline.register(new PairBranch());
        TestingBuilder testingBuilder = this.testingBuilder;
        testingBuilder.getClass();
        Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> logicTestingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder, this.settings).buildPipeline());
        Pipeline<Source, Stream<LogicSample>> testSamplesStreamPipeline = pipeline.register(new SamplesProcessingBuilder(this.settings, sources.test).buildPipeline(sources.test));
        PairMerge pairMerge = pipeline.register(new PairMerge());
        duplicateSources.connectAfterL(testExtrPipe);
        duplicateSources.connectAfterR(trainingPipeline);
        testExtrPipe.connectAfter(testSamplesStreamPipeline);
        trainingPipeline.connectAfter(pairBranch1);
        pairMerge.connectBeforeL(pairBranch1.output1);
        pairMerge.connectBeforeR(testSamplesStreamPipeline);
        pairMerge.connectAfter(logicTestingPipeline);
        this.resultsMerge.connectBeforeL(pairBranch1.output2);
        this.resultsMerge.connectBeforeR(logicTestingPipeline);
        pipeline.registerEnd(this.resultsMerge);
        return pipeline;
    }

    public class NeuralTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> {
        public NeuralTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> buildPipeline() {
            Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults> pipeline = new Pipeline<Pair<NeuralModel, Pair<Stream<NeuralSample>, Stream<NeuralSample>>>, TrainTestResults>("NeuralTrainTestPipeline", this);
            TrainingBuilder trainingBuilder = new TrainingBuilder(this.settings, TrainTestBuilder.this.sources);
            trainingBuilder.getClass();
            TrainingBuilder.NeuralLearningBuilder neuralLearningBuilder = new TrainingBuilder.NeuralLearningBuilder(trainingBuilder, this.settings);
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Pair<NeuralModel, Progress>> neuralLearning = pipeline.register(neuralLearningBuilder.buildPipeline());
            TestingBuilder testingBuilder = new TestingBuilder(this.settings, TrainTestBuilder.this.sources);
            testingBuilder.getClass();
            TestingBuilder.NeuralTestingBuilder neuralTestingBuilder = new TestingBuilder.NeuralTestingBuilder(testingBuilder, this.settings);
            Pipeline<Pair<NeuralModel, Stream<NeuralSample>>, Results> neuralTesting = pipeline.register(neuralTestingBuilder.buildPipeline());
            PairBranch modelSamplesBranch = pipeline.registerStart(new PairBranch());
            PairBranch trainTestBranch = pipeline.register(new PairBranch());
            PairBranch modelResultsBranch = pipeline.register(new PairBranch());
            PairMerge trainingMerge = pipeline.register(new PairMerge());
            PairMerge testingMerge = pipeline.register(new PairMerge());
            pipeline.registerStart(modelSamplesBranch);
            modelSamplesBranch.connectAfterL(trainingMerge.input1);
            modelSamplesBranch.connectAfterR(trainTestBranch);
            trainingMerge.connectBeforeR(trainTestBranch.output1);
            trainingMerge.connectAfter(neuralLearning);
            neuralLearning.connectAfter(modelResultsBranch);
            testingMerge.connectBeforeL(modelResultsBranch.output1);
            testingMerge.connectBeforeR(trainTestBranch.output2);
            testingMerge.connectAfter(neuralTesting);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(modelResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(neuralTesting);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }

    public class StructureTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> {
        public StructureTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> buildPipeline() {
            Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults> pipeline = new Pipeline<Pair<Stream<LogicSample>, Stream<LogicSample>>, TrainTestResults>("StructureTrainTestPipeline", this);
            PairBranch trainTestBranch = pipeline.registerStart(new PairBranch());
            TrainingBuilder trainingBuilder = TrainTestBuilder.this.trainingBuilder;
            trainingBuilder.getClass();
            Pipeline<Stream<LogicSample>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(new TrainingBuilder.StructureLearningBuilder(trainingBuilder, this.settings).buildPipeline());
            TestingBuilder testingBuilder = TrainTestBuilder.this.testingBuilder;
            testingBuilder.getClass();
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> testingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder, this.settings).buildPipeline());
            PairBranch trainResultsBranch = pipeline.register(new PairBranch());
            PairMerge testMerge = pipeline.register(new PairMerge());
            trainTestBranch.connectAfterL(trainingPipeline);
            trainingPipeline.connectAfter(trainResultsBranch);
            testMerge.connectBeforeL(trainResultsBranch.output1);
            testMerge.connectBeforeR(trainTestBranch.output2);
            testMerge.connectAfter(testingPipeline);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(trainResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(testingPipeline);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }

    public class LogicTrainTestBuilder
    extends AbstractPipelineBuilder<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> {
        public LogicTrainTestBuilder(Settings settings) {
            super(settings);
        }

        @Override
        public Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> buildPipeline() {
            Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults> pipeline = new Pipeline<Pair<Template, Pair<Stream<LogicSample>, Stream<LogicSample>>>, TrainTestResults>("LogicTrainTestPipeline", this);
            PairBranch templateSamplesBranch = pipeline.registerStart(new PairBranch());
            PairBranch trainTestBranch = pipeline.register(new PairBranch());
            PairMerge trainMerge = pipeline.register(new PairMerge());
            PairMerge testMerge = pipeline.register(new PairMerge());
            PairBranch trainResultsBranch = pipeline.register(new PairBranch());
            TrainingBuilder trainingBuilder = TrainTestBuilder.this.trainingBuilder;
            trainingBuilder.getClass();
            Pipeline<Pair<Template, Stream<LogicSample>>, Pair<Pair<Template, NeuralModel>, Progress>> trainingPipeline = pipeline.register(new TrainingBuilder.LogicLearningBuilder(trainingBuilder, this.settings).buildPipeline());
            TestingBuilder testingBuilder = TrainTestBuilder.this.testingBuilder;
            testingBuilder.getClass();
            Pipeline<Pair<Pair<Template, NeuralModel>, Stream<LogicSample>>, Results> testingPipeline = pipeline.register(new TestingBuilder.LogicTestingBuilder(testingBuilder, this.settings).buildPipeline());
            templateSamplesBranch.connectAfterR(trainTestBranch);
            trainMerge.connectBeforeL(templateSamplesBranch.output1);
            trainMerge.connectBeforeR(trainTestBranch.output1);
            trainMerge.connectAfter(trainingPipeline);
            trainingPipeline.connectAfter(trainResultsBranch);
            testMerge.connectBeforeL(trainResultsBranch.output1);
            testMerge.connectBeforeR(trainTestBranch.output2);
            testMerge.connectAfter(testingPipeline);
            TrainTestBuilder.this.resultsMerge.connectBeforeL(trainResultsBranch.output2);
            TrainTestBuilder.this.resultsMerge.connectBeforeR(testingPipeline);
            pipeline.registerEnd(TrainTestBuilder.this.resultsMerge);
            return pipeline;
        }
    }
}

