/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import networks.computation.evaluation.results.ClassificationResults;
import networks.computation.evaluation.results.Result;
import networks.computation.evaluation.results.Results;
import networks.computation.iteration.actions.Evaluation;
import networks.computation.iteration.actions.IndependentNeuronProcessing;
import networks.computation.iteration.visitors.states.neurons.Invalidator;
import networks.computation.training.NeuralModel;
import networks.computation.training.NeuralSample;
import networks.structure.components.NeuralNetwork;
import networks.structure.components.neurons.QueryNeuron;
import networks.structure.components.neurons.types.AtomNeurons;
import pipelines.Pipe;
import settings.Settings;
import utils.generic.Pair;

public class NeuralEvaluationPipe
extends Pipe<Pair<NeuralModel, Stream<NeuralSample>>, Results> {
    private static final Logger LOG = Logger.getLogger(NeuralEvaluationPipe.class.getName());
    Settings settings;

    public NeuralEvaluationPipe(Settings settings) {
        super("NeuralEvaluationPipe");
        this.settings = settings;
    }

    @Override
    public Results apply(Pair<NeuralModel, Stream<NeuralSample>> neuralModelStreamPair) {
        IndependentNeuronProcessing invalidation = new IndependentNeuronProcessing(this.settings, new Invalidator(-1));
        Evaluation evaluation = new Evaluation(this.settings);
        List collect = ((Stream)neuralModelStreamPair.s).collect(Collectors.toList());
        ArrayList<Result> resultList = new ArrayList<Result>();
        for (NeuralSample neuralSample : collect) {
            NeuralNetwork neuralNetwork = (NeuralNetwork)((QueryNeuron)neuralSample.query).evidence;
            AtomNeurons neuron = ((QueryNeuron)neuralSample.query).neuron;
            ((NeuralNetwork)((QueryNeuron)neuralSample.query).evidence).initializeStatesCache(-1);
            invalidation.process(neuralNetwork, neuron);
            Result evaluate = evaluation.evaluate(neuralSample);
            resultList.add(evaluate);
        }
        Results.Factory factory = Results.Factory.getFrom(this.settings);
        Results results = factory.createFrom(resultList);
        if (((NeuralModel)neuralModelStreamPair.r).threshold != null && results instanceof ClassificationResults) {
            ((ClassificationResults)results).getBestAccuracy(results.evaluations, ((NeuralModel)neuralModelStreamPair.r).threshold);
        }
        LOG.finer("Testing outputs");
        LOG.fine(results.toString(this.settings));
        results.printOutputs();
        return results;
    }
}

