/*
 * Decompiled with CFR 0.152.
 */
package pipelines.pipes.specific;

import constructs.example.LiftedExample;
import constructs.example.QueryAtom;
import grounding.GroundTemplate;
import grounding.Grounder;
import grounding.GroundingSample;
import java.util.logging.Logger;
import java.util.stream.Stream;
import pipelines.Pipe;

public class SequentiallySharedGroundingPipe
extends Pipe<Stream<GroundingSample>, Stream<GroundingSample>> {
    private static final Logger LOG = Logger.getLogger(SequentiallySharedGroundingPipe.class.getName());
    Grounder grounder;
    GroundTemplate stored = null;

    public SequentiallySharedGroundingPipe(Grounder grounder) {
        super("SequentiallySharedGroundingPipe");
        this.grounder = grounder;
    }

    @Override
    public Stream<GroundingSample> apply(Stream<GroundingSample> groundingSampleStream) {
        if (groundingSampleStream.isParallel()) {
            LOG.severe("Sequential sharing in a parallel grounding stream.");
            groundingSampleStream.sequential();
        }
        return groundingSampleStream.map(gs -> {
            if (gs.groundingWrap.getGroundTemplate() == null || !gs.groundingComplete) {
                gs.groundingWrap.setGroundTemplate(this.grounder.groundRulesAndFacts((LiftedExample)((QueryAtom)gs.query).evidence, gs.template, this.stored));
            }
            return gs;
        });
    }
}

