/*
 * Decompiled with CFR 0.152.
 */
package settings;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import networks.computation.evaluation.values.Value;
import org.apache.commons.cli.CommandLine;
import pipelines.Pipeline;
import utils.Utilities;
import utils.exporting.Exportable;
import utils.exporting.Exporter;
import utils.generic.Pair;

public class Settings
implements Exportable {
    private static final transient Logger LOG = Logger.getLogger(Settings.class.getName());
    public static final OS os = Utilities.getOs();
    public static boolean htmlLogging = false;
    public static boolean supressConsoleOutput = false;
    public static boolean supressLogFileOutput = true;
    public static Level loggingLevel = Level.FINER;
    public static boolean customLogColors = true;
    public static String logFile = "./out/Logging";
    public String graphvizPathLinux = "/usr/bin";
    public String graphvizPathMac = "/usr/local/bin";
    public String graphvizPathWindows = "../resources/graphviz";
    public Object blockExporting = BlockExporting.JSON;
    public boolean cleanUpFirst = true;
    public String outDir = "./out";
    public String resultFile = this.outDir + "/results";
    public String settingsExportFile = this.outDir + "/settings.json";
    public String sourcesExportFile = this.outDir + "/sources.json";
    public String console = this.outDir + "/consoleOutput";
    public String exportDir = this.outDir + "/export";
    public transient Exporter exporter;
    public String[] exportBlocks = new String[]{"NeuralTrainTestPipeline", "NeuralEvaluationPipe", "CrossvalidationPipeline", "CompressionPipe", "NetworkPruningPipe", "NeuralTrainingPipe"};
    public boolean drawing = false;
    public boolean debugPipeline = false;
    public boolean debugTemplate = false;
    public boolean debugGrounding = false;
    public boolean debugNeuralization = false;
    public boolean debugSampleTraining = false;
    public boolean debugTemplateTraining = false;
    public boolean debugSampleOutputs = false;
    public boolean intermediateDebug;
    public Detail drawingDetail = Detail.HIGH;
    public String imageFile = this.outDir + "/graph";
    public String graphVizAlgorithm = "dot";
    public String imgType = "png";
    public boolean fix2ScreenSize = false;
    public boolean storeNotShow = false;
    public boolean compactGroundingDrawing;
    public Optimize optimize = Optimize.SPEED;
    public int seed = 0;
    public transient Random random;
    public static transient NumberFormat superDetailedNumberFormat = new DecimalFormat("#.################");
    public static transient NumberFormat detailedNumberFormat = new DecimalFormat("#.##########");
    public static transient NumberFormat shortNumberFormat = new DecimalFormat("#.##");
    public transient Pipeline root;
    public MainMode mainMode = MainMode.COMPLETE;
    public boolean rebuildPipelines = false;
    public int appLimitSamples = -1;
    public boolean trainTestJointGrounding;
    public GroundingMode groundingMode = GroundingMode.STANDARD;
    public boolean possibleNeuronSharing = false;
    public boolean parallelGrounding = false;
    public GroundingAlgo grounding = GroundingAlgo.BUP;
    public AggregationFcn factMergeActivation = AggregationFcn.MAX;
    public boolean explicitSupervisedGroundTemplatePruning = false;
    public boolean forceFullNetworks = false;
    public Value defaultFactValue = Value.ONE;
    public boolean ruleAdaptiveOffset = false;
    public double defaultRuleNeuronOffset = 0.0;
    public double defaultAtomNeuronOffset = 0.0;
    public boolean defaultRuleOffsetsLearnable = false;
    public boolean defaultAtomOffsetsLearnable = false;
    public boolean neuralNetsPostProcessing = true;
    public boolean neuralNetsSupervisedPruning;
    public boolean copyOutInputOvermapping;
    public boolean calculateOutputLinks;
    public boolean cycleBreaking;
    public boolean chainPruning = false;
    public boolean isoValueCompression = false;
    public boolean losslessIsoCompression = false;
    public boolean isoGradientCompression;
    public boolean mergeIdenticalWeightedInputs = false;
    public boolean removeIdenticalUnweightedInputs = false;
    public boolean collapseActivations;
    public boolean collapseWeights;
    public boolean expandEmbeddings;
    public NeuralState neuralState = NeuralState.STANDARD;
    public boolean parentCounting;
    public boolean fullRuleNeuronStrings = false;
    public boolean fullAggNeuronStrings = false;
    public boolean pruneEvenWeightedNeurons = false;
    public int isoValueInits = 1;
    public int isoDecimals = 12;
    public boolean regression = false;
    public boolean detailedResults = false;
    public int resultsRecalculationEpochae = 10;
    public NeuronSearch neuronSearch = NeuronSearch.LINEAR;
    public int lin2bst = 9;
    public int bst2hashmap = 12;
    public int minibatchSize = 1;
    public boolean asyncParallelTraining;
    public boolean parallelTraining;
    public boolean neuralStreaming;
    public int restartCount = 1;
    public int maxCumEpochCount = 1000;
    public boolean shuffleBeforeTraining = true;
    public boolean shuffleEachEpoch = true;
    public boolean islearnRateDecay = false;
    public InitSet initializer = InitSet.SIMPLE;
    public InitDistribution initDistribution = InitDistribution.UNIFORM;
    public double randomInitScale = 2.0;
    public boolean checkNeuronSaturation = true;
    public double saturationPercentage = 0.1;
    public double constantInitValue = 0.1;
    public double initLearningRate = 0.01;
    public double dropoutRate = 0.0;
    public OptimizerSet optimizer = OptimizerSet.ADAM;
    public double validationSet = 0.1;
    public DropoutMode dropoutMode = DropoutMode.LIFTED_DROPCONNECT;
    public boolean calculateBestThreshold = true;
    public ErrorFcn errorFunction = ErrorFcn.SQUARED_DIFF;
    public AggregationFcn errorAggregationFcn = AggregationFcn.AVG;
    public ActivationFcn atomNeuronActivation = ActivationFcn.SIGMOID;
    public AggregationFcn aggNeuronActivation = AggregationFcn.AVG;
    public ActivationFcn ruleNeuronActivation = ActivationFcn.SIGMOID;
    public ActivationFcn negation = ActivationFcn.REVERSE;
    public IterationMode iterationMode = IterationMode.TOPOLOGIC;
    public double trainValidationPercentage = 1.0;
    public boolean undoWeightTrainingChanges;
    public boolean allowStructureLearning = false;
    public boolean structureLearning;
    public String sourcesFile = "sources.json";
    public String settingsFile = "settings.json";
    public boolean plaintextInput;
    public boolean sourceFiles = true;
    public boolean sourcePathProvided = false;
    public String sourcePath = ".";
    public String templateFile = "template.txt";
    public String trainExamplesFile = "trainExamples.txt";
    public String trainExamplesFile2 = "examples";
    public String testExamplesFile = "testExamples.txt";
    public String trainQueriesFile = "trainQueries.txt";
    public String trainQueriesFile2 = "queries";
    public String testQueriesFile = "testQueries.txt";
    public String foldsPrefix = "fold";
    public String queryExampleSeparator = ":-";
    public boolean crossvalidation;
    public boolean shuffleBeforeFoldSplit = true;
    public int foldsCount = 5;
    public boolean stratification = true;
    public boolean exportFolds = true;
    public boolean trainFoldsIsolation = false;
    public boolean commonTemplate;
    public boolean processMetadata = true;
    public boolean graphTemplate = true;
    public boolean reduceTemplate = true;
    public boolean inferTemplateFacts = true;
    public boolean supervisedTemplateGraphPruning = false;
    public boolean oneQueryPerExample = true;
    public boolean queriesAlignedWithExamples;
    public double defaultSampleImportance = 1.0;
    public String sampleIdPrefix = "s_";
    public String queriesBatchPrefix = "b_";

    public Settings setupFromCommandline(CommandLine cmd) {
        Settings settings = this;
        if (cmd.hasOption("settings")) {
            String _settingsPath = cmd.getOptionValue("settings");
            settings = this.loadFromJson(_settingsPath);
        }
        if (cmd.hasOption("out")) {
            settings.outDir = cmd.getOptionValue("out");
        }
        if (cmd.hasOption("xval")) {
            String _xval = cmd.getOptionValue("xval", String.valueOf(this.foldsCount));
            settings.foldsCount = Integer.parseInt(_xval);
        }
        if (cmd.hasOption("seed")) {
            String _seed = cmd.getOptionValue("seed", String.valueOf(this.seed));
            settings.random = new Random(Integer.parseInt(_seed));
        }
        if (cmd.hasOption("groundingAlgorithm")) {
            String _groundingAlgorithm;
            switch (_groundingAlgorithm = cmd.getOptionValue("groundingAlgorithm", this.grounding.name())) {
                case "BUp": {
                    settings.grounding = GroundingAlgo.BUP;
                    break;
                }
                case "TDown": {
                    settings.grounding = GroundingAlgo.TDOWN;
                    break;
                }
                case "Gringo": {
                    settings.grounding = GroundingAlgo.GRINGO;
                }
            }
        }
        if (cmd.hasOption("groundingMode")) {
            String _groundingMode;
            switch (_groundingMode = cmd.getOptionValue("groundingMode", "normal")) {
                case "normal": {
                    settings.groundingMode = GroundingMode.STANDARD;
                    break;
                }
                case "sequential": {
                    settings.groundingMode = GroundingMode.SEQUENTIAL;
                    break;
                }
                case "global": {
                    settings.groundingMode = GroundingMode.GLOBAL;
                }
            }
        }
        if (cmd.hasOption("weightInit")) {
            String _weightInit = cmd.getOptionValue("weightInit", String.valueOf((Object)this.initDistribution));
            switch (_weightInit.toLowerCase()) {
                case "uniform": {
                    settings.initDistribution = InitDistribution.UNIFORM;
                    break;
                }
                case "constant": {
                    settings.initDistribution = InitDistribution.CONSTANT;
                    break;
                }
                default: {
                    LOG.severe("unrecognized init distribution: " + _weightInit);
                }
            }
        }
        if (cmd.hasOption("optimizer")) {
            String _optimizer = cmd.getOptionValue("optimizer", String.valueOf((Object)this.optimizer));
            switch (_optimizer.toLowerCase()) {
                case "sgd": {
                    settings.optimizer = OptimizerSet.SGD;
                    break;
                }
                case "adam": {
                    settings.optimizer = OptimizerSet.ADAM;
                    break;
                }
                default: {
                    LOG.severe("unrecognized optimizer: " + _optimizer);
                }
            }
        }
        if (cmd.hasOption("learningRate")) {
            String _learningRate = cmd.getOptionValue("learningRate", String.valueOf(this.initLearningRate));
            settings.initLearningRate = Double.parseDouble(_learningRate);
        }
        if (cmd.hasOption("trainingSteps")) {
            String _trainingSteps = cmd.getOptionValue("trainingSteps", String.valueOf(this.maxCumEpochCount));
            settings.maxCumEpochCount = Integer.parseInt(_trainingSteps);
        }
        if (cmd.hasOption("evaluationMode")) {
            String _evaluationMode;
            switch (_evaluationMode = cmd.getOptionValue("evaluationMode", "classification")) {
                case "classification": {
                    settings.regression = false;
                    break;
                }
                case "regression": {
                    settings.regression = true;
                }
            }
        }
        if (cmd.hasOption("errorFunction")) {
            String _errorFunction;
            switch (_errorFunction = cmd.getOptionValue("errorFunction", "MSE")) {
                case "MSE": {
                    settings.errorFunction = ErrorFcn.SQUARED_DIFF;
                    settings.errorAggregationFcn = AggregationFcn.AVG;
                    break;
                }
                case "XEnt": {
                    LOG.severe("XEnt not yet implemented");
                }
            }
        }
        if (cmd.hasOption("sourcePath")) {
            settings.sourcePathProvided = true;
        }
        if (cmd.hasOption("mode")) {
            String _mode = cmd.getOptionValue("mode", String.valueOf((Object)this.mainMode));
            switch (_mode.toLowerCase()) {
                case "complete": {
                    settings.mainMode = MainMode.COMPLETE;
                    break;
                }
                case "neuralization": {
                    settings.mainMode = MainMode.NEURALIZATION;
                    break;
                }
                case "debug": {
                    settings.mainMode = MainMode.DEBUGGING;
                }
            }
        }
        if (cmd.hasOption("debug")) {
            String _debug;
            switch (_debug = cmd.getOptionValue("debug")) {
                case "template": {
                    settings.debugTemplate = true;
                    break;
                }
                case "grounding": {
                    settings.debugGrounding = true;
                    break;
                }
                case "neuralization": {
                    settings.debugNeuralization = true;
                    break;
                }
                case "samples": {
                    settings.debugSampleTraining = true;
                    break;
                }
                case "model": {
                    settings.debugTemplateTraining = true;
                }
            }
        }
        if (cmd.hasOption("limitExamples")) {
            String _limit = cmd.getOptionValue("limitExamples");
            settings.appLimitSamples = Integer.parseInt(_limit);
        }
        if (cmd.hasOption("isoCompression")) {
            String _isoCompression = cmd.getOptionValue("isoCompression", String.valueOf(this.isoDecimals));
            settings.isoDecimals = Integer.parseInt(_isoCompression);
            if (settings.isoDecimals > 0) {
                settings.neuralNetsPostProcessing = true;
                settings.isoValueCompression = true;
            } else {
                settings.isoValueCompression = false;
            }
        }
        if (cmd.hasOption("isoInitializations")) {
            String _isoInits = cmd.getOptionValue("isoInitializations");
            settings.isoValueInits = Integer.parseInt(_isoInits);
        }
        if (cmd.hasOption("losslessCompression")) {
            String _losslessCompression = cmd.getOptionValue("losslessCompression");
            boolean bl = settings.losslessIsoCompression = Integer.parseInt(_losslessCompression) > 0;
        }
        if (cmd.hasOption("chainPruning")) {
            String _pruning = cmd.getOptionValue("chainPruning", String.valueOf(this.chainPruning));
            int prune = Integer.parseInt(_pruning);
            if (prune > 0) {
                settings.neuralNetsPostProcessing = true;
                settings.chainPruning = true;
            } else {
                settings.chainPruning = false;
            }
        }
        return settings;
    }

    public Pair<Boolean, String> validate() {
        boolean valid = true;
        StringBuilder message = new StringBuilder();
        if (this.groundingMode == GroundingMode.SEQUENTIAL) {
            if (this.parallelGrounding) {
                valid = false;
            }
            message.append("Not possible");
        }
        if (!this.oneQueryPerExample && this.explicitSupervisedGroundTemplatePruning) {
            valid = false;
        }
        if (this.stratification && this.regression) {
            message.append("stratification not possible with regression");
            valid = false;
        }
        return new Pair<Boolean, StringBuilder>(valid, message);
    }

    public void infer() {
        this.random = new Random(this.seed);
        if (this.reduceTemplate) {
            this.graphTemplate = true;
        }
        boolean bl = this.parentCounting = this.iterationMode != IterationMode.TOPOLOGIC;
        if (this.dropoutRate == 0.0 && !this.parentCounting) {
            this.neuralState = NeuralState.STANDARD;
        } else if (this.dropoutRate == 0.0 && this.parentCounting) {
            this.neuralState = NeuralState.PARENTS;
        } else if (this.dropoutRate > 0.0 && this.parentCounting) {
            this.neuralState = NeuralState.PAR_DROPOUT;
        }
        if (this.groundingMode == GroundingMode.SEQUENTIAL) {
            this.forceFullNetworks = true;
            this.possibleNeuronSharing = true;
        }
        if (this.groundingMode == GroundingMode.GLOBAL) {
            this.possibleNeuronSharing = true;
            this.neuralNetsSupervisedPruning = false;
        }
        this.resultFile = this.outDir + "/results";
        this.settingsExportFile = this.outDir + "/settings.json";
        this.sourcesExportFile = this.outDir + "/sources.json";
        this.console = this.outDir + "/consoleOutput";
        this.exportDir = this.outDir + "/export";
        this.neuralNetsPostProcessing = this.chainPruning || this.isoValueCompression || this.neuralNetsSupervisedPruning || this.copyOutInputOvermapping || this.isoGradientCompression || this.mergeIdenticalWeightedInputs || this.removeIdenticalUnweightedInputs || this.cycleBreaking || this.collapseWeights || this.expandEmbeddings;
        this.finish();
    }

    private void finish() {
        this.exporter = new Exporter(this);
        if (this.cleanUpFirst) {
            this.exporter.deleteDir(new File(this.exportDir));
        }
        this.exporter.exportSettings(this);
    }

    public void importFromCSV(String inPath) {
    }

    public Settings loadFromJson(String inPath) {
        InstanceCreator<Settings> creator = new InstanceCreator<Settings>(){

            @Override
            public Settings createInstance(Type type) {
                return Settings.this;
            }
        };
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Settings.class), creator).create();
        try {
            String json = new String(Files.readAllBytes(Paths.get(inPath, new String[0])));
            Settings settings = gson.fromJson(json, Settings.class);
            return settings;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void exportToCSV(String outPath) {
    }

    public class Inferred {
    }

    public static enum IterationMode {
        TOPOLOGIC,
        DFS_RECURSIVE,
        DFS_STACK,
        BFS;

    }

    public static enum AggregationFcn {
        AVG,
        MAX,
        MIN,
        SUM;

    }

    public static enum ErrorFcn {
        SQUARED_DIFF,
        ABS_DIFF,
        CROSSENTROPY;

    }

    public static enum ActivationFcn {
        SIGMOID,
        TANH,
        SIGNUM,
        LUKASIEWICZ,
        RELU,
        IDENTITY,
        REVERSE;

    }

    public static enum DropoutMode {
        DROPOUT,
        DROPCONNECT,
        LIFTED_DROPCONNECT;

    }

    public static enum OptimizerSet {
        SGD,
        ADAM;

    }

    public static enum InitDistribution {
        UNIFORM,
        CONSTANT;

    }

    public static enum InitSet {
        SIMPLE,
        GLOROT;

    }

    public static enum NeuronSearch {
        LINEAR,
        BST,
        HASHMAP;

    }

    public static enum NeuralState {
        STANDARD,
        PARENTS,
        DROPOUT,
        PAR_DROPOUT;

    }

    public static enum GroundingAlgo {
        BUP,
        TDOWN,
        GRINGO;

    }

    public static enum GroundingMode {
        STANDARD,
        SEQUENTIAL,
        GLOBAL;

    }

    public static enum MainMode {
        COMPLETE,
        NEURALIZATION,
        DEBUGGING;

    }

    public static enum Optimize {
        MEMORY,
        SPEED,
        TRADEOFF;

    }

    public static enum Detail {
        LOW,
        MEDIUM,
        HIGH;

    }

    public static enum BlockExporting {
        JSON,
        TEXT;

    }

    public static enum OS {
        LINUX,
        MACOSX,
        WINDOWS;

    }
}

