/*
 * Decompiled with CFR 0.152.
 */
package utils.drawing;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import pipelines.Block;
import pipelines.Branch;
import pipelines.ConnectAfter;
import pipelines.Merge;
import pipelines.MultiBranch;
import pipelines.MultiMerge;
import pipelines.ParallelPipe;
import pipelines.Pipe;
import pipelines.Pipeline;
import pipelines.pipes.generic.IdentityGenPipe;
import settings.Settings;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;
import utils.drawing.Drawer;
import utils.drawing.GraphViz;

public class PipelineDrawer<S, T>
extends Drawer<Pipeline<S, T>> {
    private static final Logger LOG = Logger.getLogger(PipelineDrawer.class.getName());

    public PipelineDrawer(Settings settings) {
        super(settings);
    }

    @Override
    public void loadGraph(Pipeline<S, T> pipeline) {
        this.graphviz.addln("strict digraph {");
        this.graphviz.addln("compound=true");
        this.loadPipeline(pipeline);
        this.graphviz.end_graph();
    }

    private void loadPipeline(Pipeline<S, T> pipeline) {
        for (Map.Entry<String, Pipe> entry : pipeline.pipes.entrySet()) {
            this.draw(entry.getValue());
        }
        for (Map.Entry<String, Block> entry : pipeline.branches.entrySet()) {
            this.draw((Branch)entry.getValue());
        }
        for (Map.Entry<String, Block> entry : pipeline.merges.entrySet()) {
            this.draw((Merge)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pipeline.multiPipes.entrySet()) {
            this.draw((ParallelPipe)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pipeline.multiBranches.entrySet()) {
            this.draw((MultiBranch)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pipeline.multiMerges.entrySet()) {
            this.draw((MultiMerge)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : pipeline.pipelines.entrySet()) {
            this.drawInnerPipeline((Pipeline)entry.getValue());
        }
        this.drawStart(this.getStartElement(pipeline));
        this.drawTerminal(this.getTerminalElement(pipeline));
    }

    private void drawStart(Object start) {
        this.graphviz.addln(this.getNodeId(start) + "[label=" + GraphViz.sanitize(start.toString()) + ", color=green]");
    }

    private void drawTerminal(Object terminal) {
        if (terminal != null) {
            this.graphviz.addln(this.getNodeId(terminal) + "[label=" + GraphViz.sanitize(terminal.toString()) + ", color=red]");
        }
    }

    @Override
    private void draw(Pipe pipe) {
        ArrayList<String> types = GenericTypeGetter.getTypes(pipe);
        if (pipe instanceof IdentityGenPipe) {
            this.graphviz.addln(this.getNodeId(pipe) + "[shape=point, width=0.1, height=0.1]");
        } else {
            this.graphviz.addln(this.getNodeId(pipe) + "[label=" + GraphViz.sanitize(pipe.toString()) + ", shape=cds]");
        }
        if (pipe.input != null) {
            this.drawEdge(pipe.input, pipe, "label=" + GraphViz.sanitize(types.get(0)));
        }
        if (pipe.output != null) {
            this.drawEdge(pipe, pipe.output, "label=" + GraphViz.sanitize(types.get(1)));
        }
    }

    @Override
    private void draw(Branch branch) {
        this.graphviz.addln(this.getNodeId(branch) + "[label=" + GraphViz.sanitize(branch.toString()) + ", shape=trapezium]");
        if (branch.input != null) {
            this.drawEdge(branch.input, branch);
        }
        if (branch.output1 != null) {
            this.drawEdge(branch, branch.output1);
        }
        if (branch.output2 != null) {
            this.drawEdge(branch, branch.output2);
        }
    }

    @Override
    private void draw(Merge merge) {
        this.graphviz.addln(this.getNodeId(merge) + "[label=" + GraphViz.sanitize(merge.toString()) + ", shape=invtrapezium]");
        if (merge.input1 != null) {
            this.graphviz.addln(this.getNodeId(merge.input1) + "[shape=point, width=0.1, height=0.1]");
        }
        this.drawEdge(merge.input1, merge);
        if (merge.input2 != null) {
            this.graphviz.addln(this.getNodeId(merge.input2) + "[shape=point, width=0.1, height=0.1]");
        }
        this.drawEdge(merge.input2, merge);
        if (merge.output != null) {
            this.drawEdge(merge, merge.output);
        }
    }

    @Override
    private void draw(ParallelPipe pipe) {
        this.graphviz.addln(pipe.hashCode() + "[label=" + this.getNodeId(pipe.toString()) + "]");
        for (ConnectAfter connectAfter : pipe.inputs) {
            this.graphviz.addln(connectAfter.hashCode() + " -> " + pipe.hashCode());
        }
        for (Object object : pipe.outputs) {
            this.graphviz.addln(pipe.hashCode() + " -> " + object.hashCode());
        }
    }

    @Override
    private void draw(MultiBranch branch) {
        this.graphviz.addln(this.getNodeId(branch) + "[label=" + GraphViz.sanitize(branch.toString()) + ", shape=trapezium]");
        if (branch.input != null) {
            this.graphviz.addln(this.getNodeId(branch.input) + " -> " + branch.hashCode());
        }
        for (IdentityGenPipe output : branch.outputs) {
            this.graphviz.addln(branch.hashCode() + " -> " + output.hashCode());
        }
    }

    @Override
    private void draw(MultiMerge merge) {
        this.graphviz.addln(this.getNodeId(merge) + "[label=" + GraphViz.sanitize(merge.toString()) + ", shape=invtrapezium]");
        for (Pipe input : merge.inputs) {
            this.graphviz.addln(input.hashCode() + " -> " + merge.hashCode());
        }
        if (merge.output != null) {
            this.graphviz.addln(merge.hashCode() + " -> " + this.getNodeId(merge.output));
        }
    }

    private void drawInnerPipeline(Pipeline pipeline) {
        this.graphviz.addln("subgraph cluster_" + pipeline.hashCode() + " {");
        this.loadPipeline(pipeline);
        this.graphviz.addln("label=" + GraphViz.sanitize(pipeline.toString()) + "}");
        if (pipeline.input != null) {
            this.drawEdge(pipeline.input, pipeline);
        }
        if (pipeline.output != null) {
            this.drawEdge(pipeline, pipeline.output);
        }
    }

    private void drawEdge(Object obj1, Object obj2) {
        this.drawEdge(obj1, obj2, "");
    }

    private void drawEdge(Object obj1, Object obj2, String attributes) {
        if (obj1 instanceof Pipeline) {
            attributes = attributes + " ltail=" + this.getNodeId(obj1);
        }
        if (obj2 instanceof Pipeline) {
            attributes = attributes + " lhead=" + this.getNodeId(obj2);
        }
        String node1 = this.getEnd(obj1);
        String node2 = this.getStart(obj2);
        this.graphviz.addln(node1 + " -> " + node2 + "[" + attributes + "]");
    }

    private String getStart(Object obj) {
        if (obj instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)obj;
            return this.getNodeId(pipeline.start);
        }
        return this.getNodeId(obj);
    }

    private String getEnd(Object obj) {
        if (obj instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)obj;
            if (pipeline.terminal != null) {
                return this.getNodeId(pipeline.terminal);
            }
            LOG.severe("Pipeline without terminal");
            return this.getNodeId(pipeline.start);
        }
        return this.getNodeId(obj);
    }

    private String getNodeId(Object object) {
        int hashCode = object.hashCode();
        if (object instanceof Pipeline) {
            return "cluster_" + hashCode;
        }
        return String.valueOf(hashCode);
    }

    private Object getStartElement(Object object) {
        if (object instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)object;
            return this.getStartElement(pipeline.start);
        }
        return object;
    }

    private Object getTerminalElement(Object object) {
        if (object instanceof Pipeline) {
            Pipeline pipeline = (Pipeline)object;
            return this.getTerminalElement(pipeline.terminal);
        }
        return object;
    }

    private static class GenericTypeGetter {
        private GenericTypeGetter() {
        }

        public static ArrayList<String> getTypes(Object object) {
            try {
                Type genericSuperclass = object.getClass().getGenericSuperclass();
                Type[] actualTypeArguments = ((ParameterizedType)genericSuperclass).getActualTypeArguments();
                return GenericTypeGetter.recurseTypes(actualTypeArguments);
            }
            catch (Exception e) {
                LOG.warning("Java error while hacking around with reflection for recovering generics at runtime.");
                return null;
            }
        }

        private static ArrayList<String> recurseTypes(Type[] actualTypeArguments) {
            ArrayList<String> types = new ArrayList<String>();
            for (Type actualTypeArgument : actualTypeArguments) {
                types.add(GenericTypeGetter.getCompoundType(actualTypeArgument) + ",");
            }
            return types;
        }

        private static String getCompoundType(Type actualTypeArgument) {
            String simpleName = "";
            try {
                if (actualTypeArgument instanceof Class) {
                    Class aClass = (Class)actualTypeArgument;
                    simpleName = aClass.getSimpleName();
                } else if (actualTypeArgument instanceof ParameterizedType) {
                    Type[] actualTypeArguments = ((ParameterizedType)actualTypeArgument).getActualTypeArguments();
                    simpleName = Arrays.toString(GenericTypeGetter.recurseTypes(actualTypeArguments).toArray());
                } else if (actualTypeArgument instanceof TypeVariableImpl) {
                    TypeVariableImpl typeVariable = (TypeVariableImpl)actualTypeArgument;
                    simpleName = typeVariable.getName();
                }
            }
            catch (ClassCastException e) {
                System.out.println();
            }
            return simpleName;
        }
    }
}

