/*
 * Decompiled with CFR 0.152.
 */
package utils.exporting;

import java.util.logging.Logger;
import learning.crossvalidation.TrainTestResults;
import networks.computation.evaluation.results.Progress;
import networks.computation.evaluation.results.Results;
import settings.Settings;
import utils.exporting.Exporter;

public class TextExporter
extends Exporter {
    private static final Logger LOG = Logger.getLogger(TextExporter.class.getName());

    public TextExporter(Settings settings, String id) {
        super(settings, id);
    }

    public void export(TrainTestResults trainTestResults) {
        this.resultsLine("TrainTestResults:");
        trainTestResults.training.bestResults.export(this);
        this.resultsLine("Testing:");
        trainTestResults.testing.export(this);
    }

    public void export(Results results) {
        this.resultsLine(results.toString(this.settings));
    }

    public void export(Progress.TrainVal trainVal) {
        this.resultsLine("TrainVal:");
        this.resultsLine("Training:");
        trainVal.training.export(this);
        this.resultsLine("Validation:");
        trainVal.validation.export(this);
    }

    public void export(Progress progress) {
        this.resultsLine("Progress:");
        this.resultsLine("BestResults:");
        progress.bestResults.export(this);
        this.resultsLine("Training");
        for (Progress.Restart restart : progress.restarts) {
            this.resultsLine("onlineTrainingResults-----------------");
            for (Results onlineTrainingResult : restart.onlineTrainingResults) {
                this.export(onlineTrainingResult);
            }
            this.resultsLine("trueTrainingResults----------------");
            for (Results trueTrainingResult : restart.trueTrainingResults) {
                this.export(trueTrainingResult);
            }
            this.resultsLine("validationResults------------------");
            for (Results validationResult : restart.validationResults) {
                this.export(validationResult);
            }
        }
    }
}

