/*
 * Decompiled with CFR 0.152.
 */
package utils.logging;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import settings.Settings;
import utils.logging.ColoredFormatter;
import utils.logging.FlushStreamHandler;
import utils.logging.HtmlFormatter;

public class Logging {
    private static final Logger LOG = Logger.getLogger(Logging.class.getName());
    private FileHandler loggingFile;
    Formatter fileFormatter;
    Formatter consoleFormatter;
    long startupTime = System.currentTimeMillis();

    public static Logging initLogging() {
        return Logging.initLogging(Settings.loggingLevel);
    }

    public static Logging initLogging(Level loggingLevel) {
        Logging logging = new Logging();
        try {
            logging.initialize(loggingLevel);
            LOG.info("Launched NeuraLogic from location " + System.getProperty("user.dir"));
        }
        catch (IOException ex) {
            LOG.severe("Could not initialize Logging.\n" + ex.getMessage());
            System.exit(1);
        }
        return logging;
    }

    public void initialize(Level loggingLevel) throws IOException {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT [%4$s] (%2$s) : %5$s%6$s%n");
        System.setProperty("java.util.logging.ConsoleHandler.level", "FINEST");
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        Handler defaultConsoleHandler = handlers[0];
        if (defaultConsoleHandler instanceof ConsoleHandler) {
            rootLogger.removeHandler(defaultConsoleHandler);
            if (!Settings.supressConsoleOutput) {
                this.consoleFormatter = Settings.customLogColors ? new ColoredFormatter() : new SimpleFormatter();
                FlushStreamHandler sh = new FlushStreamHandler(System.out, this.consoleFormatter);
                sh.setLevel(loggingLevel);
                rootLogger.addHandler(sh);
            }
        }
        rootLogger.setLevel(loggingLevel);
        if (!Settings.supressLogFileOutput) {
            File parentFile = new File(Settings.logFile).getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            if (Settings.htmlLogging) {
                this.loggingFile = new FileHandler(Settings.logFile + ".html");
                this.fileFormatter = new HtmlFormatter();
            } else {
                this.loggingFile = new FileHandler(Settings.logFile + ".txt");
                this.fileFormatter = new SimpleFormatter();
            }
            this.loggingFile.setFormatter(this.fileFormatter);
            rootLogger.addHandler(this.loggingFile);
        }
    }

    public void finish() {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.info("Total time: " + Logging.calcDate(System.currentTimeMillis() - this.startupTime));
    }

    public static String calcDate(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("HH:mm:ss:SS");
        date_format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }
}

