/*
 * Decompiled with CFR 0.152.
 */
package auc;

import auc.Confusion;
import auc.ReadList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public class AUCCalculator {
    private static String fileName;
    private static String fileType;
    private static double posCount;
    private static double negCount;
    private static double minRecall;
    public static boolean DEBUG;

    public static void main(String[] stringArray) {
        AUCCalculator.readArgs((String[])stringArray);
        Confusion confusion = fileType.equalsIgnoreCase("list") ? ReadList.readFile((String)fileName, (String)fileType) : AUCCalculator.readFile((String)fileName, (String)fileType, (double)posCount, (double)negCount);
        confusion.writePRFile(fileName + ".pr");
        confusion.writeStandardPRFile(fileName + ".spr");
        confusion.writeROCFile(fileName + ".roc");
        confusion.calculateAUCPR(minRecall);
        confusion.calculateAUCROC();
    }

    public static void readArgs(String[] stringArray) {
        fileName = "";
        int n = 2;
        try {
            fileName = stringArray[0];
            fileType = stringArray[1];
            if (!(fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC") || fileType.equalsIgnoreCase("list"))) {
                throw new NoSuchElementException();
            }
            if (fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC")) {
                posCount = Double.parseDouble(stringArray[2]);
                negCount = Double.parseDouble(stringArray[3]);
                n = 4;
                if (posCount < 1.0 || negCount < 1.0) {
                    throw new NumberFormatException();
                }
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.err.println("ERROR: Missing Arguments - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <fileType> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("ERROR: Incorrect Count arguments, must be positive numbers - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("ERROR: Incorrect fileType, must be ROC, PR, LIST - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        try {
            minRecall = Double.parseDouble(stringArray[n]);
            if (minRecall < 0.0 || minRecall > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("ERROR: Incorrect minRecall argument, must be positive between 0 and 1 - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
    }

    public static Confusion readFile(String string, String string2, double d, double d2) {
        if (DEBUG) {
            System.out.println("--- Reading in " + string2 + " File: " + string + " ---");
        }
        Confusion confusion = new Confusion(d, d2);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(string)));
            if (!(string2.equals("PR") || string2.equals("ROC") || string2.equals("pr") || string2.equals("roc"))) {
                throw new NoSuchElementException();
            }
            while (bufferedReader.ready()) {
                String string3 = bufferedReader.readLine();
                if (DEBUG) {
                    System.out.println(string3);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string3, "\t ,");
                try {
                    double d3 = Double.parseDouble(stringTokenizer.nextToken());
                    double d4 = Double.parseDouble(stringTokenizer.nextToken());
                    if (DEBUG) {
                        System.out.println(d3 + "\t" + d4);
                    }
                    if (string2.equals("PR")) {
                        confusion.addPRPoint(d3, d4);
                    } else {
                        confusion.addROCPoint(d3, d4);
                    }
                    if (!DEBUG) continue;
                    System.out.println("End of Line");
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
                catch (NoSuchElementException noSuchElementException) {
                    System.err.println("...skipping bad input line (missing data)");
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("ERROR: File " + string + " not found - exiting...");
            System.exit(-1);
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println("...incorrect fileType argument, either PR or ROC - exiting");
            System.exit(-1);
        }
        catch (IOException iOException) {
            System.err.println("ERROR: IO Exception in file " + string + " - exiting...");
            System.exit(-1);
        }
        confusion.sort();
        confusion.interpolate();
        return confusion;
    }

    public static Confusion readArrays(int[] nArray, double[] dArray) {
        if (nArray.length != dArray.length || nArray.length == 0) {
            System.err.println(nArray.length + " " + dArray.length);
            System.err.println("ERROR: incorrect array lengths - exiting");
            System.exit(-1);
        }
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 0) {
                d2 += 1.0;
                continue;
            }
            if (nArray[i] == 1) {
                d += 1.0;
                continue;
            }
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        Confusion confusion = new Confusion(d, d2);
        double d3 = 0.0;
        double d4 = 0.0;
        if (nArray[0] == 0) {
            d4 += 1.0;
        } else if (nArray[0] == 1) {
            d3 += 1.0;
        } else {
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        for (int i = 1; i < dArray.length; ++i) {
            if (dArray[i] != dArray[i - 1]) {
                try {
                    confusion.addPoint(d3, d4);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
            }
            if (nArray[i] == 0) {
                d4 += 1.0;
                continue;
            }
            if (nArray[i] == 1) {
                d3 += 1.0;
                continue;
            }
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        confusion.addPoint(d3, d4);
        confusion.sort();
        confusion.interpolate();
        return confusion;
    }

    static {
        minRecall = 0.0;
        DEBUG = false;
    }
}

