/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.Activation;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CrossProduct
extends Activation {
    private static final Logger LOG = Logger.getLogger(CrossProduct.class.getName());
    Activation activation;

    @Override
    public String getName() {
        return "CrossProduct";
    }

    @Override
    public Aggregation replaceWithSingleton() {
        LOG.severe("CrossProduct cannot be singleton");
        return null;
    }

    public CrossProduct(Activation activation) {
        super(activation.evaluation, activation.gradient);
        this.activation = activation;
    }

    @Override
    public boolean isInputSymmetric() {
        return false;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        ArrayList<Value> values = new ArrayList<Value>(inputs.size());
        values.addAll(inputs);
        ArrayList<Double> outputVector = new ArrayList<Double>();
        this.combinationsRecursive(outputVector, 0.0, values);
        return this.activation.evaluate(new VectorValue(outputVector));
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        ArrayList<Value> clone = new ArrayList<Value>(inputs.size());
        clone.addAll(inputs);
        ArrayList<Double> outputVector = new ArrayList<Double>();
        this.combinationsRecursive(outputVector, 0.0, clone);
        return this.activation.differentiate(new VectorValue(outputVector));
    }

    private void combinationsRecursive(List<Double> output, double sum, List<Value> values) {
        if (values.size() == 0) {
            output.add(sum);
            return;
        }
        Value removed = values.remove(0);
        for (Double next : removed) {
            this.combinationsRecursive(output, sum += next.doubleValue(), values);
            sum -= next.doubleValue();
        }
        values.add(0, removed);
    }
}

