/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.functions;

import cz.cvut.fel.ida.algebra.functions.Activation;
import cz.cvut.fel.ida.algebra.functions.Aggregation;
import cz.cvut.fel.ida.algebra.values.Value;
import java.util.List;
import java.util.logging.Logger;

public class ElementProduct
extends Activation {
    private static final Logger LOG = Logger.getLogger(ElementProduct.class.getName());
    Activation activation;

    @Override
    public String getName() {
        return "DotProduct";
    }

    public ElementProduct(Activation activation) {
        super(activation.evaluation, activation.gradient);
        this.activation = activation;
    }

    @Override
    public Aggregation replaceWithSingleton() {
        LOG.severe("ElementProduct cannot be singleton.");
        return null;
    }

    @Override
    public Value evaluate(List<Value> inputs) {
        Value sum = this.sumInputs(inputs);
        return this.activation.evaluate(sum);
    }

    @Override
    public Value differentiate(List<Value> inputs) {
        Value sum = this.sumInputs(inputs);
        return this.activation.differentiate(sum);
    }

    private Value sumInputs(List<Value> inputs) {
        int[] size = inputs.get(0).size();
        Value sum = inputs.get(0).getForm();
        for (Value input : inputs) {
            sum.incrementBy(input);
        }
        return sum;
    }
}

