/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values;

import com.sun.istack.internal.NotNull;
import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;
import java.util.logging.Logger;

public abstract class Value
implements Iterable<Double>,
Comparable<Value>,
Serializable {
    private static final Logger LOG = Logger.getLogger(Value.class.getName());
    public static final Value ZERO = new Zero();
    public static final Value ONE = new One();

    public abstract void initialize(ValueInitializer var1);

    public abstract Value zero();

    public abstract Value clone();

    public abstract Value getForm();

    public abstract void transpose();

    public abstract Value transposedView();

    public abstract int[] size();

    public abstract Value apply(Function<Double, Double> var1);

    public abstract double get(int var1);

    public abstract void set(int var1, double var2);

    public abstract void increment(int var1, double var2);

    public abstract String toString();

    public String toDetailedString() {
        return this.toString();
    }

    public abstract Value times(Value var1);

    protected abstract Value times(ScalarValue var1);

    protected abstract Value times(VectorValue var1);

    protected abstract Value times(MatrixValue var1);

    public abstract Value elementTimes(Value var1);

    protected abstract Value elementTimes(ScalarValue var1);

    protected abstract Value elementTimes(VectorValue var1);

    protected abstract Value elementTimes(MatrixValue var1);

    public abstract Value plus(Value var1);

    protected abstract Value plus(ScalarValue var1);

    protected abstract Value plus(VectorValue var1);

    protected abstract Value plus(MatrixValue var1);

    public abstract Value minus(Value var1);

    protected abstract Value minus(ScalarValue var1);

    protected abstract Value minus(VectorValue var1);

    protected abstract Value minus(MatrixValue var1);

    public abstract void incrementBy(Value var1);

    protected abstract void incrementBy(ScalarValue var1);

    protected abstract void incrementBy(VectorValue var1);

    protected abstract void incrementBy(MatrixValue var1);

    public abstract boolean greaterThan(Value var1);

    protected abstract boolean greaterThan(ScalarValue var1);

    protected abstract boolean greaterThan(VectorValue var1);

    protected abstract boolean greaterThan(MatrixValue var1);

    public abstract boolean equals(Value var1);

    @Override
    public int compareTo(Value o) {
        if (this.greaterThan(o)) {
            return 1;
        }
        if (o.greaterThan(this)) {
            return -1;
        }
        return 0;
    }

    @Deprecated
    private static class Zero
    extends Value {
        private ScalarValue zero = new ScalarValue(0.0);

        private Zero() {
        }

        @Override
        public void initialize(ValueInitializer valueInitializer) {
        }

        @Override
        public Value zero() {
            return this.zero;
        }

        @Override
        public Value clone() {
            LOG.fine("Cloning a constant ZERO");
            return this;
        }

        @Override
        public Value getForm() {
            return this;
        }

        @Override
        public void transpose() {
        }

        @Override
        public Value transposedView() {
            return this;
        }

        @Override
        public int[] size() {
            return new int[0];
        }

        @Override
        public Value apply(Function<Double, Double> function) {
            return this.zero.apply(function);
        }

        @Override
        public double get(int i) {
            if (i != 0) {
                LOG.severe("Scalar value: asking for i-th element!");
            }
            return this.zero.value;
        }

        @Override
        public void set(int i, double value) {
            if (i != 0) {
                LOG.severe("Scalar value: asking for i-th element!");
            }
            LOG.warning("Trying to set value i constant ONE");
        }

        @Override
        public void increment(int i, double value) {
            if (i != 0) {
                LOG.severe("Scalar value: asking for i-th element!");
            }
            LOG.warning("Trying to increment value i constant ONE");
        }

        @Override
        public String toString() {
            return "0";
        }

        @Override
        public Value times(Value value) {
            return this.zero;
        }

        @Override
        public Value times(ScalarValue value) {
            return this.zero;
        }

        @Override
        public Value times(VectorValue value) {
            return this.zero;
        }

        @Override
        public Value times(MatrixValue value) {
            return this.zero;
        }

        @Override
        public Value elementTimes(Value value) {
            return this.zero;
        }

        @Override
        protected Value elementTimes(ScalarValue value) {
            return this.zero;
        }

        @Override
        protected Value elementTimes(VectorValue value) {
            return this.zero;
        }

        @Override
        protected Value elementTimes(MatrixValue value) {
            return this.zero;
        }

        @Override
        public Value plus(Value value) {
            return value;
        }

        @Override
        public Value plus(ScalarValue value) {
            return value;
        }

        @Override
        public Value plus(VectorValue value) {
            return value;
        }

        @Override
        public Value plus(MatrixValue value) {
            return value;
        }

        @Override
        public Value minus(Value value) {
            return value;
        }

        @Override
        public Value minus(ScalarValue value) {
            return value;
        }

        @Override
        public Value minus(VectorValue value) {
            return value;
        }

        @Override
        public Value minus(MatrixValue value) {
            return value;
        }

        @Override
        public void incrementBy(Value value) {
            LOG.warning("Trying to increment a constant ZERO");
        }

        @Override
        public void incrementBy(ScalarValue value) {
        }

        @Override
        public void incrementBy(VectorValue value) {
        }

        @Override
        public void incrementBy(MatrixValue value) {
        }

        @Override
        public boolean greaterThan(Value maxValue) {
            return maxValue.greaterThan(this.zero);
        }

        @Override
        public boolean greaterThan(ScalarValue maxValue) {
            return this.zero.greaterThan(maxValue);
        }

        @Override
        public boolean greaterThan(VectorValue maxValue) {
            return this.zero.greaterThan(maxValue);
        }

        @Override
        public boolean greaterThan(MatrixValue maxValue) {
            return this.zero.greaterThan(maxValue);
        }

        @Override
        public boolean equals(Value obj) {
            return obj instanceof Zero;
        }

        @Override
        @NotNull
        public Iterator<Double> iterator() {
            return this.zero.iterator();
        }
    }

    private static class One
    extends Value {
        private ScalarValue one = new ScalarValue(1.0);

        private One() {
        }

        @Override
        public void initialize(ValueInitializer valueInitializer) {
        }

        @Override
        public Value zero() {
            LOG.warning("Constant One cannot be zeroed!");
            return null;
        }

        @Override
        public Value clone() {
            return new ScalarValue(1.0);
        }

        @Override
        public Value getForm() {
            return new ScalarValue(0.0);
        }

        @Override
        public void transpose() {
        }

        @Override
        public Value transposedView() {
            return this;
        }

        @Override
        public int[] size() {
            return new int[0];
        }

        @Override
        public Value apply(Function<Double, Double> function) {
            return this.one.apply(function);
        }

        @Override
        public double get(int i) {
            if (i != 0) {
                LOG.severe("Scalar value: asking for i-th element!");
            }
            return this.one.value;
        }

        @Override
        public void set(int i, double value) {
            if (i != 0) {
                LOG.severe("Scalar value: asking for i-th element!");
            }
            LOG.warning("Trying to set value i constant ONE");
        }

        @Override
        public void increment(int i, double value) {
            LOG.warning("Trying to increment value i constant ONE");
        }

        @Override
        public String toString() {
            return "1";
        }

        @Override
        public Value times(Value value) {
            return value;
        }

        @Override
        public Value times(ScalarValue value) {
            return value;
        }

        @Override
        public Value times(VectorValue value) {
            return value;
        }

        @Override
        public Value times(MatrixValue value) {
            return value;
        }

        @Override
        public Value elementTimes(Value value) {
            return value;
        }

        @Override
        protected Value elementTimes(ScalarValue value) {
            return value;
        }

        @Override
        protected Value elementTimes(VectorValue value) {
            return value;
        }

        @Override
        protected Value elementTimes(MatrixValue value) {
            return value;
        }

        @Override
        public Value plus(Value value) {
            return value.plus(this.one);
        }

        @Override
        public Value plus(ScalarValue value) {
            return value.plus(this.one);
        }

        @Override
        public Value plus(VectorValue value) {
            return value.plus(this.one);
        }

        @Override
        public Value plus(MatrixValue value) {
            return value.plus(this.one);
        }

        @Override
        public Value minus(Value value) {
            return value.minus(this.one);
        }

        @Override
        public Value minus(ScalarValue value) {
            return this.one.minus(value);
        }

        @Override
        public Value minus(VectorValue value) {
            return this.one.minus(value);
        }

        @Override
        public Value minus(MatrixValue value) {
            return this.one.minus(value);
        }

        @Override
        public void incrementBy(Value value) {
            LOG.warning("Trying to increment a constant ONE");
        }

        @Override
        public void incrementBy(ScalarValue value) {
            this.one.incrementBy(value);
        }

        @Override
        public void incrementBy(VectorValue value) {
            this.one.incrementBy(value);
        }

        @Override
        public void incrementBy(MatrixValue value) {
            this.one.incrementBy(value);
        }

        @Override
        public boolean greaterThan(Value maxValue) {
            return maxValue.greaterThan(this.one);
        }

        @Override
        public boolean greaterThan(ScalarValue maxValue) {
            return this.one.greaterThan(maxValue);
        }

        @Override
        public boolean greaterThan(VectorValue maxValue) {
            return this.one.greaterThan(maxValue);
        }

        @Override
        public boolean greaterThan(MatrixValue maxValue) {
            return this.one.greaterThan(maxValue);
        }

        @Override
        public boolean equals(Value obj) {
            return obj instanceof One;
        }

        @Override
        @NotNull
        public Iterator<Double> iterator() {
            return this.one.iterator();
        }
    }
}

