/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values.inits;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.distributions.Uniform;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class GlorotUniformInitializer
implements ValueInitializer {
    private static final Logger LOG = Logger.getLogger(GlorotUniformInitializer.class.getName());
    Uniform distribution;

    public GlorotUniformInitializer(Settings settings) {
        this.distribution = new Uniform(settings.random, settings);
    }

    @Override
    public void initScalar(ScalarValue scalar) {
        double limit = this.getLimit(scalar);
        scalar.value = this.distribution.getDoubleValue(-limit, limit);
    }

    @Override
    public void initVector(VectorValue vector) {
        double limit = this.getLimit(vector);
        for (int i = 0; i < vector.values.length; ++i) {
            vector.values[i] = this.distribution.getDoubleValue(-limit, limit);
        }
    }

    @Override
    public void initMatrix(MatrixValue matrix) {
        double limit = this.getLimit(matrix);
        for (int i = 0; i < matrix.rows; ++i) {
            for (int j = 0; j < matrix.cols; ++j) {
                matrix.values[i][j] = this.distribution.getDoubleValue(-limit, limit);
            }
        }
    }

    protected double getLimit(MatrixValue value) {
        return Math.sqrt(6.0) / Math.sqrt(value.cols + value.rows);
    }

    protected double getLimit(VectorValue value) {
        return Math.sqrt(6.0) / Math.sqrt(value.values.length + 1);
    }

    protected double getLimit(ScalarValue value) {
        return Math.sqrt(6.0) / Math.sqrt(2.0);
    }
}

