/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.algebra.values.inits;

import cz.cvut.fel.ida.algebra.values.MatrixValue;
import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.VectorValue;
import cz.cvut.fel.ida.algebra.values.distributions.Distribution;
import cz.cvut.fel.ida.algebra.values.inits.ValueInitializer;
import cz.cvut.fel.ida.setup.Settings;
import java.util.logging.Logger;

public class SimpleInitializer
implements ValueInitializer {
    private static final Logger LOG = Logger.getLogger(SimpleInitializer.class.getName());
    Distribution distribution;

    public SimpleInitializer(Settings settings) {
        this.distribution = Distribution.getDistribution(settings);
    }

    @Override
    public void initScalar(ScalarValue scalar) {
        scalar.value = this.distribution.getDoubleValue();
    }

    @Override
    public void initVector(VectorValue vector) {
        for (int i = 0; i < vector.values.length; ++i) {
            vector.values[i] = this.distribution.getDoubleValue();
        }
    }

    @Override
    public void initMatrix(MatrixValue matrix) {
        for (int i = 0; i < matrix.rows; ++i) {
            for (int j = 0; j < matrix.cols; ++j) {
                matrix.values[i][j] = this.distribution.getDoubleValue();
            }
        }
    }
}

