/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.learning.results.metrics.Jesse.unused;

import cz.cvut.fel.ida.learning.results.metrics.Jesse.Confusions;
import cz.cvut.fel.ida.learning.results.metrics.Jesse.unused.ReadList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class AUCCalculator {
    private static final Logger LOG = Logger.getLogger(AUCCalculator.class.getName());
    private static String fileName;
    private static String fileType;
    private static double posCount;
    private static double negCount;
    private static double minRecall;
    public static boolean DEBUG;

    public static void main(String[] var0) {
        AUCCalculator.readArgs(var0);
        Confusions confusions = fileType.equalsIgnoreCase("list") ? ReadList.readFile(fileName, fileType) : AUCCalculator.readFile(fileName, fileType, posCount, negCount);
        confusions.calculateAUCPR(minRecall);
        confusions.calculateAUCROC();
    }

    public static void readArgs(String[] var0) {
        fileName = "";
        int var1 = 2;
        try {
            fileName = var0[0];
            fileType = var0[1];
            if (!(fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC") || fileType.equalsIgnoreCase("list"))) {
                throw new NoSuchElementException();
            }
            if (fileType.equalsIgnoreCase("PR") || fileType.equalsIgnoreCase("ROC")) {
                posCount = Double.parseDouble(var0[2]);
                negCount = Double.parseDouble(var0[3]);
                var1 = 4;
                if (posCount < 1.0 || negCount < 1.0) {
                    throw new NumberFormatException();
                }
            }
        }
        catch (IndexOutOfBoundsException var5) {
            System.err.println("ERROR: Missing Arguments - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <fileType> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NumberFormatException var6) {
            System.err.println("ERROR: Incorrect Count arguments, must be positive numbers - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        catch (NoSuchElementException var7) {
            System.err.println("ERROR: Incorrect fileType, must be ROC, PR, LIST - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
        try {
            minRecall = Double.parseDouble(var0[var1]);
            if (minRecall < 0.0 || minRecall > 1.0) {
                throw new NumberFormatException();
            }
        }
        catch (IndexOutOfBoundsException var7) {
        }
        catch (NumberFormatException var4) {
            System.err.println("ERROR: Incorrect minRecall argument, must be positive between 0 and 1 - exiting...");
            System.err.println("Usage:\njava AUCCalculator <fileName> <posCount*> <negCount*> <minRecall**>");
            System.err.println("   posCount and negCount required if fileType ROC or PR");
            System.err.println("   minRecall always optional");
            System.exit(-1);
        }
    }

    public static Confusions readFile(String var0, String var1, double var2, double var4) {
        if (DEBUG) {
            System.out.println("--- Reading in " + var1 + " File: " + var0 + " ---");
        }
        Confusions confusions = new Confusions(var2, var4);
        BufferedReader var7 = null;
        try {
            var7 = new BufferedReader(new FileReader(new File(var0)));
            if (!(var1.equals("PR") || var1.equals("ROC") || var1.equals("pr") || var1.equals("roc"))) {
                throw new NoSuchElementException();
            }
            while (var7.ready()) {
                String var8 = var7.readLine();
                if (DEBUG) {
                    System.out.println(var8);
                }
                StringTokenizer var9 = new StringTokenizer(var8, "\t ,");
                try {
                    double var10 = Double.parseDouble(var9.nextToken());
                    double var12 = Double.parseDouble(var9.nextToken());
                    if (DEBUG) {
                        System.out.println(var10 + "\t" + var12);
                    }
                    if (var1.equals("PR")) {
                        confusions.addPRPoint(var10, var12);
                    } else {
                        confusions.addROCPoint(var10, var12);
                    }
                    if (!DEBUG) continue;
                    System.out.println("End of Line");
                }
                catch (NumberFormatException var14) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
                catch (NoSuchElementException var15) {
                    System.err.println("...skipping bad input line (missing data)");
                }
            }
        }
        catch (FileNotFoundException var16) {
            System.err.println("ERROR: File " + var0 + " not found - exiting...");
            System.exit(-1);
        }
        catch (NoSuchElementException var17) {
            System.err.println("...incorrect fileType argument, either PR or ROC - exiting");
            System.exit(-1);
        }
        catch (IOException var18) {
            System.err.println("ERROR: IO Exception in file " + var0 + " - exiting...");
            System.exit(-1);
        }
        confusions.sort();
        confusions.interpolate();
        return confusions;
    }

    public static Confusions readArrays(int[] var0, double[] var1) {
        if (var0.length != var1.length || var0.length == 0) {
            System.err.println(var0.length + " " + var1.length);
            System.err.println("ERROR: incorrect array lengths - exiting");
            System.exit(-1);
        }
        double var2 = 0.0;
        double var4 = 0.0;
        for (int var6 = 0; var6 < var0.length; ++var6) {
            if (var0[var6] == 0) {
                var4 += 1.0;
                continue;
            }
            if (var0[var6] == 1) {
                var2 += 1.0;
                continue;
            }
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        Confusions var14 = new Confusions(var2, var4);
        double var7 = 0.0;
        double var9 = 0.0;
        if (var0[0] == 0) {
            var9 += 1.0;
        } else if (var0[0] == 1) {
            var7 += 1.0;
        } else {
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        for (int var11 = 1; var11 < var1.length; ++var11) {
            if (var1[var11] != var1[var11 - 1]) {
                try {
                    var14.addPoint(var7, var9);
                }
                catch (NumberFormatException var13) {
                    System.err.println("...skipping bad input line (bad numbers)");
                }
            }
            if (var0[var11] == 0) {
                var9 += 1.0;
                continue;
            }
            if (var0[var11] == 1) {
                var7 += 1.0;
                continue;
            }
            System.err.println("ERROR: example not 0 or 1 - exiting");
            System.exit(-1);
        }
        var14.addPoint(var7, var9);
        var14.sort();
        var14.interpolate();
        return var14;
    }

    static {
        minRecall = 0.0;
        DEBUG = false;
    }
}

