/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logging;

import cz.cvut.fel.ida.logging.ColoredFormatter;
import cz.cvut.fel.ida.logging.FlushStreamHandler;
import cz.cvut.fel.ida.logging.HtmlFormatter;
import cz.cvut.fel.ida.logging.NormalFormatter;
import cz.cvut.fel.ida.setup.Settings;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Logging {
    private static final Logger LOG = Logger.getLogger(Logging.class.getName());
    public static File logFile;
    private FileHandler loggingFile;
    Formatter fileFormatter;
    Formatter consoleFormatter;
    long startupTime = System.currentTimeMillis();

    public static Logging initLogging() throws Exception {
        Locale.setDefault(Locale.US);
        return Logging.initLogging(Settings.loggingLevel, Settings.supressLogFileOutput);
    }

    public static Logging initTestLogging(String testName) throws Exception {
        Settings.logFile = "./testlog/" + testName + "_" + Logging.calcDateTime(System.currentTimeMillis());
        logFile = new File(Settings.logFile);
        Settings.htmlLogging = false;
        return Logging.initLogging(Settings.loggingLevel, false);
    }

    public static Logging initLogging(Level loggingLevel, boolean noLogFile) throws Exception {
        Logging logging = new Logging();
        try {
            logging.initialize(loggingLevel, noLogFile);
            LOG.info("Launched NeuraLogic from location " + System.getProperty("user.dir"));
        }
        catch (IOException ex) {
            throw new Exception("Could not initialize Logging.\n" + ex.getMessage());
        }
        return logging;
    }

    public void initialize(Level loggingLevel, boolean noLogFile) throws IOException {
        System.setProperty("java.util.logging.SimpleFormatter.format", "%1$tF %1$tT [%4$s] (%2$s) : %5$s%6$s%n");
        System.setProperty("java.util.logging.ConsoleHandler.level", "FINEST");
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        Handler defaultConsoleHandler = handlers[0];
        if (defaultConsoleHandler instanceof ConsoleHandler) {
            rootLogger.removeHandler(defaultConsoleHandler);
            if (!Settings.supressConsoleOutput) {
                this.consoleFormatter = Settings.customLogColors ? new ColoredFormatter() : new NormalFormatter();
                FlushStreamHandler sh = new FlushStreamHandler(System.out, this.consoleFormatter);
                sh.setLevel(loggingLevel);
                rootLogger.addHandler(sh);
            }
        }
        rootLogger.setLevel(loggingLevel);
        if (!noLogFile) {
            String file = null;
            File parentFile = new File(Settings.logFile).getParentFile();
            if (parentFile != null) {
                parentFile.mkdirs();
            }
            if (Settings.htmlLogging) {
                file = Settings.logFile + ".html";
                this.fileFormatter = new HtmlFormatter();
            } else {
                file = Settings.logFile + ".txt";
                this.fileFormatter = new NormalFormatter();
            }
            this.loggingFile = new FileHandler(file);
            this.loggingFile.setFormatter(this.fileFormatter);
            rootLogger.addHandler(this.loggingFile);
        }
    }

    public void finish() {
        Handler[] handlers;
        Logger rootLogger = Logger.getLogger("");
        rootLogger.getResourceBundleName();
        for (Handler handler : handlers = rootLogger.getHandlers()) {
            if (!(handler instanceof FileHandler)) continue;
            rootLogger.removeHandler(handler);
            handler.close();
        }
        rootLogger.info("Total time: " + Logging.calcTime(System.currentTimeMillis() - this.startupTime));
    }

    public static String calcTime(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("HH:mm:ss:SS");
        date_format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }

    public static String calcDateTime(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("YYYY-MM-DD_HH-mm-ss");
        date_format.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }
}

