/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Function;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.ParserUtils;
import cz.cvut.fel.ida.logic.PrologList;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.logic.subsumption.SpecialBinaryPredicates;
import cz.cvut.fel.ida.logic.subsumption.SpecialVarargPredicates;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.collections.FakeMap;
import cz.cvut.fel.ida.utils.math.collections.ValueToIndex;
import cz.cvut.fel.ida.utils.math.hypergraphs.Hypergraph;
import cz.cvut.fel.ida.utils.math.hypergraphs.HypergraphUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class LogicUtils {
    private LogicUtils() {
    }

    public static Variable freshVariable(Clause c) {
        return LogicUtils.freshVariable(c.variables(), 0);
    }

    public static Variable freshVariable(Set<Variable> variables) {
        return LogicUtils.freshVariable(variables, 0);
    }

    public static Variable freshVariable(Set<Variable> variables, int index) {
        Variable var = null;
        while (variables.contains(var = Variable.construct("V" + index++))) {
        }
        return var;
    }

    public static Set<Variable> freshVariables(Set<Variable> variables, int num) {
        HashSet<Variable> retVal = new HashSet<Variable>();
        HashSet<Variable> all = new HashSet<Variable>(variables);
        for (int i = 0; i < num; ++i) {
            Variable v = LogicUtils.freshVariable(all, i + 1 + variables.size());
            all.add(v);
            retVal.add(v);
        }
        return retVal;
    }

    public static Clause clauseFromFunctionsList(PrologList pl) {
        HashSet<Literal> literals = new HashSet<Literal>();
        for (int i = 0; i < pl.countItems(); ++i) {
            Function f = (Function)pl.get(i);
            literals.add(f.toLiteral());
        }
        return new Clause(literals);
    }

    public static Clause substitute(Clause c, Term a, Term b) {
        return LogicUtils.substitute(c, new Term[]{a}, new Term[]{b});
    }

    public static Literal substitute(Literal l, Term a, Term b) {
        return LogicUtils.substitute(l, new Term[]{a}, new Term[]{b});
    }

    public static Literal substitute(Literal l, Term[] source, Term[] image) {
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        for (int i = 0; i < source.length; ++i) {
            substitution.put(source[i], image[i]);
        }
        return LogicUtils.substitute(l, substitution);
    }

    public static Literal substitute(Literal l, Map<Term, Term> substitution) {
        Literal newLiteral = new Literal(l.predicateName(), l.isNegated(), l.arity());
        for (int i = 0; i < l.arity(); ++i) {
            if (substitution.containsKey(l.get(i))) {
                newLiteral.set(substitution.get(l.get(i)), i);
                continue;
            }
            newLiteral.set(l.get(i), i);
        }
        return newLiteral;
    }

    public static Term unquote(Term term) {
        String name = term.name();
        if (name.length() > 0 && name.charAt(0) == '\'' && name.charAt(name.length() - 1) == '\'') {
            name = name.substring(1, name.length() - 1);
        }
        return (Term)ParserUtils.parseTerm((char[])name.toCharArray(), (int)0, (char)')', new HashMap<Variable, Variable>(), new HashMap<Constant, Constant>()).r;
    }

    public static String niceVariableName(int id) {
        if (id <= 25) {
            return String.valueOf((char)(65 + id));
        }
        return String.valueOf((char)(65 + id % 25)) + id / 25;
    }

    public static Clause variabilizeClause(Clause c) {
        return LogicUtils.variabilizeClause(c, null);
    }

    public static Clause variabilizeClause(Clause c, Clause template) {
        HashMap<Pair<String, Integer>, Literal> map = new HashMap<Pair<String, Integer>, Literal>();
        if (template != null) {
            for (Literal l : template.literals()) {
                map.put(new Pair<String, Integer>(l.predicateName(), l.arity()), l);
            }
        }
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        HashSet<Variable> usedVariables = new HashSet<Variable>(c.variables());
        Pair<String, Integer> query = new Pair<String, Integer>();
        int freshVariableIndex = 1;
        for (Literal l : c.literals()) {
            query.set(l.predicateName(), l.arity());
            Literal templateLit = (Literal)map.get(query);
            for (int i = 0; i < l.arity(); ++i) {
                if (template != null && templateLit.get(i).name().equals("#") || !(l.get(i) instanceof Constant) || substitution.containsKey(l.get(i))) continue;
                Variable newVar = LogicUtils.toVariable(l.get(i));
                if (usedVariables.contains(newVar)) {
                    newVar = LogicUtils.freshVariable(usedVariables, freshVariableIndex++);
                }
                substitution.put(l.get(i), newVar);
                usedVariables.add(newVar);
            }
        }
        return LogicUtils.substitute(c, substitution);
    }

    public static Variable toVariable(Term term) {
        return Variable.construct(Sugar.firstCharacterToUpperCase(term.name()), term.type());
    }

    public static Variable toVariable(Term term, String type) {
        return Variable.construct(Sugar.firstCharacterToUpperCase(term.name()), type);
    }

    public static Constant toConstant(Term term) {
        return Constant.construct(Sugar.firstCharacterToLowerCase(term.name()), term.type());
    }

    public static Constant toConstant(Term term, String type) {
        return Constant.construct(Sugar.firstCharacterToLowerCase(term.name()), type);
    }

    public static Term parseTerm(String s) {
        if ((s = s.trim()).charAt(0) == '[') {
            return Function.parseFunction(s, new FakeMap<Variable, Variable>(), new FakeMap<Constant, Constant>());
        }
        if (Character.isLowerCase(s.charAt(0))) {
            return Constant.construct(s);
        }
        return Variable.construct(s);
    }

    public static Clause constantizeClause(Clause c) {
        LinkedHashSet<Literal> predicates = new LinkedHashSet<Literal>();
        for (Literal l : c.literals()) {
            Literal newPred = new Literal(l.predicateName(), l.isNegated(), l.arity());
            for (int i = 0; i < l.arity(); ++i) {
                newPred.set((Term)Constant.construct(Sugar.firstCharacterToLowerCase(l.get(i).name())), i);
            }
            predicates.add(newPred);
        }
        return new Clause(predicates);
    }

    public static List<String> freshPredicateNames(Clause c, int count) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && retVal.size() != count; ++i) {
            String pred = "pred_" + i;
            if (!c.getLiteralsByPredicate(pred).isEmpty()) continue;
            retVal.add("pred" + i);
        }
        return retVal;
    }

    public static List<String> freshPredicateNames(Set<String> c, int count) {
        ArrayList<String> retVal = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && retVal.size() != count; ++i) {
            String pred = "pred_" + i;
            if (c.contains(pred)) continue;
            retVal.add("pred" + i);
        }
        return retVal;
    }

    public static boolean isGround(Clause c) {
        return c.variables().isEmpty();
    }

    public static boolean isGround(Literal l) {
        for (int i = 0; i < l.arity(); ++i) {
            if (!(l.get(i) instanceof Variable)) continue;
            return false;
        }
        return true;
    }

    public static Pair<Clause, Clause> standardizeApart(Clause a, Clause b) {
        Pair<Clause, Clause> retVal = new Pair<Clause, Clause>();
        int i = 0;
        for (Clause c : LogicUtils.standardizeApart(Sugar.list(a, b))) {
            if (i == 0) {
                retVal.r = c;
            } else {
                retVal.s = c;
            }
            ++i;
        }
        return retVal;
    }

    public static Collection<Clause> standardizeApart(Collection<Clause> clauses) {
        ArrayList<Clause> retVal = new ArrayList<Clause>();
        HashMap vars = new HashMap();
        HashSet<Variable> allVariables = new HashSet<Variable>();
        for (Clause c : clauses) {
            for (Variable v : c.variables()) {
                allVariables.add(v);
            }
        }
        int i = 0;
        for (Clause c : clauses) {
            HashSet<Literal> literals = new HashSet<Literal>();
            Pair<Variable, Integer> queryPair = new Pair<Variable, Integer>();
            for (Literal l : c.literals()) {
                Literal newLiteral = new Literal(l.predicateName(), l.isNegated(), l.arity());
                for (int j = 0; j < l.arity(); ++j) {
                    if (l.get(j) instanceof Variable) {
                        queryPair.set((Variable)l.get(j), i);
                        Variable var = null;
                        var = (Variable)vars.get(queryPair);
                        if (var == null) {
                            Pair insertPair = new Pair(queryPair.r, queryPair.s);
                            var = LogicUtils.freshVariable(allVariables);
                            allVariables.add(var);
                            vars.put(insertPair, var);
                        }
                        newLiteral.set((Term)var, j);
                        continue;
                    }
                    newLiteral.set(l.get(j), j);
                }
                literals.add(newLiteral);
            }
            retVal.add(new Clause(literals));
            ++i;
        }
        return retVal;
    }

    public static boolean isTreelike(Clause c) {
        return HypergraphUtils.isTreelike(LogicUtils.clause2hypergraph(c));
    }

    public static boolean isAcyclic(Clause c) {
        return HypergraphUtils.isAcyclic(LogicUtils.clause2hypergraph(c));
    }

    private static Hypergraph clause2hypergraph(Clause c) {
        ValueToIndex<Variable> vertexIDs = new ValueToIndex<Variable>();
        ValueToIndex<HashSet<Integer>> edgeIDs = new ValueToIndex<HashSet<Integer>>();
        Hypergraph h = new Hypergraph();
        for (Literal l : c.literals()) {
            HashSet<Integer> edge = new HashSet<Integer>();
            for (int i = 0; i < l.arity(); ++i) {
                if (!(l.get(i) instanceof Variable)) continue;
                edge.add(vertexIDs.valueToIndex((Variable)l.get(i)));
            }
            h.addEdge(edgeIDs.valueToIndex(edge), edge);
        }
        return h;
    }

    public static Clause randomlyRenameVariables(Clause clause, int newVariableIndex) {
        return LogicUtils.randomlyRenameVariables(clause, newVariableIndex, new Random());
    }

    public static Clause randomlyRenameVariables(Clause clause, int newVariableIndex, Random random) {
        ArrayList<Variable> newVariables = new ArrayList<Variable>();
        int numVariables = clause.variables().size();
        for (int i = 0; i < numVariables; ++i) {
            newVariables.add(Variable.construct(LogicUtils.niceVariableName(newVariableIndex + i)));
        }
        Collections.shuffle(newVariables, random);
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        int index = 0;
        for (Variable oldVar : clause.variables()) {
            substitution.put(oldVar, (Term)newVariables.get(index++));
        }
        return LogicUtils.substitute(clause, substitution);
    }

    public static Clause randomlyRenameConstants(Clause clause, int newConstantIndex) {
        return LogicUtils.randomlyRenameConstants(clause, newConstantIndex, new Random());
    }

    public static Clause randomlyRenameConstants(Clause clause, int newConstantIndex, Random random) {
        ArrayList<Constant> newConstants = new ArrayList<Constant>();
        int numConstants = 0;
        for (Term term : clause.terms()) {
            if (!(term instanceof Constant)) continue;
            ++numConstants;
        }
        for (int i = 0; i < numConstants; ++i) {
            newConstants.add(Constant.construct(LogicUtils.niceVariableName(newConstantIndex + i).toLowerCase()));
        }
        Collections.shuffle(newConstants, random);
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        int index = 0;
        for (Term oldTerm : clause.terms()) {
            if (!(oldTerm instanceof Constant)) continue;
            substitution.put(oldTerm, (Term)newConstants.get(index++));
        }
        return LogicUtils.substitute(clause, substitution);
    }

    public static Set<Variable> variables(Collection<Clause> ... clauses) {
        HashSet<Variable> retVal = new HashSet<Variable>();
        for (Collection<Clause> clauseColl : clauses) {
            for (Clause c : clauseColl) {
                retVal.addAll(c.variables());
            }
        }
        return retVal;
    }

    public static Set<Term> terms(Collection<Clause> ... clauses) {
        HashSet<Term> retVal = new HashSet<Term>();
        for (Collection<Clause> clauseColl : clauses) {
            for (Clause c : clauseColl) {
                retVal.addAll(c.terms());
            }
        }
        return retVal;
    }

    public static Set<String> predicateNamesOfLiterals(Collection<Literal> ... literals) {
        HashSet<String> retVal = new HashSet<String>();
        for (Collection<Literal> literalColl : literals) {
            for (Literal l : literalColl) {
                retVal.add(l.predicateName());
            }
        }
        return retVal;
    }

    public static Set<Pair<String, Integer>> predicates(Collection<Clause> clauses) {
        return LogicUtils.predicates(clauses, false);
    }

    public static Set<Pair<String, Integer>> predicates(Collection<Clause> clauses, boolean ignoreSpecialPredicates) {
        HashSet<Pair<String, Integer>> retVal = new HashSet<Pair<String, Integer>>();
        for (Clause c : clauses) {
            retVal.addAll(LogicUtils.predicates(c, ignoreSpecialPredicates));
        }
        return retVal;
    }

    public static Set<Pair<String, Integer>> predicates(Clause c) {
        return LogicUtils.predicates(c, false);
    }

    public static Set<Pair<String, Integer>> predicates(Clause c, boolean ignoreSpecialPredicates) {
        HashSet<Pair<String, Integer>> retVal = new HashSet<Pair<String, Integer>>();
        for (Literal l : c.literals()) {
            if (ignoreSpecialPredicates && (SpecialBinaryPredicates.SPECIAL_PREDICATES.contains(l.predicateName()) || SpecialVarargPredicates.SPECIAL_PREDICATES.contains(l.predicateName()))) continue;
            retVal.add(new Pair<String, Integer>(l.predicateName(), l.arity()));
        }
        return retVal;
    }

    public static Set<String> predicateNames(Collection<Clause> ... clauses) {
        HashSet<String> retVal = new HashSet<String>();
        for (Collection<Clause> clauseColl : clauses) {
            for (Clause c : clauseColl) {
                retVal.addAll(c.predicates());
            }
        }
        return retVal;
    }

    public static Set<Literal> atoms(Clause clause) {
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (Literal l : clause.literals()) {
            if (l.isNegated()) {
                retVal.add(l.negation());
                continue;
            }
            retVal.add(l);
        }
        return retVal;
    }

    public static Set<Literal> atoms(Collection<Clause> ... clauses) {
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (Collection<Clause> clauseColl : clauses) {
            for (Clause c : clauseColl) {
                retVal.addAll(LogicUtils.atoms(c));
            }
        }
        return retVal;
    }

    public static boolean isGround(Collection<Clause> ... clauses) {
        for (Collection<Clause> clauseColl : clauses) {
            for (Clause c : clauseColl) {
                if (LogicUtils.isGround(c)) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String[] args) {
        System.out.println(LogicUtils.variabilizeClause(Clause.parse("lit(a,A), lit(b,c)"), Clause.parse("lit(x,#)")));
        System.out.println(LogicUtils.randomlyRenameConstants(Clause.parse("l1(a,b), l2(b,c), l3(c,d)"), 1));
    }

    public static Clause flipSigns(Clause c) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        for (Literal l : c.literals()) {
            literals.add(l.negation());
        }
        return new Clause(literals);
    }

    public static List<Literal> flipSigns(Collection<Literal> literals) {
        ArrayList<Literal> retVal = new ArrayList<Literal>();
        for (Literal l : literals) {
            retVal.add(l.negation());
        }
        return retVal;
    }

    public static Clause substitute(Clause c, Term[] variables, Term[] terms) {
        HashMap<Term, Term> subs = new HashMap<Term, Term>();
        for (int i = 0; i < variables.length; ++i) {
            subs.put(variables[i], terms[i]);
        }
        return LogicUtils.substitute(c, subs);
    }

    public static Clause substitute(Clause c, Map<Term, Term> substitution) {
        HashSet<Literal> literals = new HashSet<Literal>();
        for (Literal l : c.literals()) {
            Literal groundCopy = LogicUtils.substitute(l, substitution);
            literals.add(groundCopy);
        }
        return new Clause(literals);
    }

    public static boolean isModelOf(Set<Literal> possibleWorld, Clause clause) {
        for (Literal l : clause.literals()) {
            if (!possibleWorld.contains(l)) continue;
            return true;
        }
        return false;
    }

    public static boolean isModelOf(Set<Literal> possibleWorld, Collection<Clause> theory) {
        for (Clause c : theory) {
            if (LogicUtils.isModelOf(possibleWorld, c)) continue;
            return false;
        }
        return true;
    }

    public static Literal termToLiteral(Term term) {
        if (term instanceof Constant) {
            return new Literal(term.name(), new Term[0]);
        }
        if (term instanceof Function) {
            return ((Function)term).toLiteral();
        }
        if (term instanceof Variable) {
            throw new IllegalArgumentException("Variables cannot be converted into literals.");
        }
        throw new IllegalArgumentException("Only constants and functions supported.");
    }

    public static Set<Constant> constants(Clause c) {
        HashSet<Constant> retVal = new HashSet<Constant>();
        for (Term t : c.terms()) {
            if (!(t instanceof Constant)) continue;
            retVal.add((Constant)t);
        }
        return retVal;
    }

    public static Set<Constant> constants(Collection<Clause> coll) {
        HashSet<Constant> retVal = new HashSet<Constant>();
        for (Clause c : coll) {
            retVal.addAll(LogicUtils.constants(c));
        }
        return retVal;
    }

    private static Literal literalTemplate(Literal l) {
        int j = 0;
        Literal normalized = new Literal(l.predicateName(), l.isNegated(), l.arity());
        for (int i = 0; i < l.arity(); ++i) {
            if (l.get(i) instanceof Variable) {
                Variable v = (Variable)l.get(i);
                normalized.set((Term)Variable.construct("V" + j++, v.type()), i);
                continue;
            }
            normalized.set(l.get(i), i);
        }
        return normalized;
    }

    public static Set<Literal> allGroundAtoms(Collection<Clause> clauses) {
        return LogicUtils.allGroundAtoms_impl(clauses, new HashSet<Constant>());
    }

    public static Set<Literal> allGroundAtoms(Collection<Pair<String, Integer>> predicates, Collection<Constant> constants) {
        ArrayList<Clause> clauses = new ArrayList<Clause>();
        for (Pair<String, Integer> p : predicates) {
            clauses.add(new Clause(LogicUtils.newLiteral((String)p.r, (Integer)p.s)));
        }
        return LogicUtils.allGroundAtoms_impl(clauses, constants);
    }

    private static Set<Literal> allGroundAtoms_impl(Collection<Clause> clauses, Collection<Constant> constants) {
        HashSet<Literal> retVal = new HashSet<Literal>();
        HashSet<Constant> constantSet = new HashSet<Constant>();
        constantSet.addAll(constants);
        for (Clause c : clauses) {
            constantSet.addAll(LogicUtils.constants(c));
        }
        Literal lit = new Literal("", true, constantSet.size());
        int i = 0;
        for (Constant constant : constantSet) {
            lit.set((Term)constant, i++);
        }
        HashSet<Literal> normalized = new HashSet<Literal>();
        for (Clause c : clauses) {
            for (Literal l : c.literals()) {
                normalized.add(LogicUtils.literalTemplate(l));
            }
        }
        Matching matching = new Matching(Sugar.list(new Clause(lit)));
        for (Literal l : normalized) {
            if (!l.isNegated()) {
                l = l.negation();
            }
            Pair<Term[], List<Term[]>> p = matching.allSubstitutions(new Clause(l), 0, Integer.MAX_VALUE);
            for (Term[] subs : (List)p.s) {
                retVal.add(LogicUtils.substitute(l, (Term[])p.r, subs).negation());
            }
        }
        return retVal;
    }

    public static Set<Clause> allGroundings(Collection<Clause> clauses, Collection<Constant> constants) {
        HashSet<Clause> retVal = new HashSet<Clause>();
        Literal lit = new Literal("", true, constants.size());
        int i = 0;
        for (Constant c : constants) {
            lit.set((Term)c, i++);
        }
        Matching m = new Matching(Sugar.list(new Clause(lit)));
        for (Clause c : clauses) {
            Literal template = new Literal("l", true, c.variables().size());
            i = 0;
            for (Variable v : c.variables()) {
                template.set((Term)v, i++);
            }
            Pair<Term[], List<Term[]>> p = m.allSubstitutions(new Clause(template), 0, Integer.MAX_VALUE);
            for (Term[] subs : (List)p.s) {
                retVal.add(LogicUtils.substitute(c, (Term[])p.r, subs));
            }
        }
        return retVal;
    }

    public static Literal newLiteral(String predicate, int arity) {
        Literal l = new Literal(predicate, arity);
        for (int i = 0; i < arity; ++i) {
            l.set((Term)Variable.construct("V" + i), i);
        }
        return l;
    }

    public static Literal newLiteral(String predicate, int arity, Collection<Variable> freshVariables) {
        Literal l = new Literal(predicate, arity);
        int i = 0;
        for (Variable v : freshVariables) {
            l.set((Term)v, i);
            if (++i < arity) continue;
            break;
        }
        return l;
    }

    public static Clause induced(Clause clause, Set<? extends Term> terms) {
        ArrayList<Literal> literals = new ArrayList<Literal>();
        block0: for (Literal l : clause.literals()) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!terms.contains(l.get(i))) continue block0;
            }
            literals.add(l);
        }
        return new Clause(literals);
    }
}

