/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic;

import cz.cvut.fel.ida.logic.Constant;
import cz.cvut.fel.ida.logic.Function;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.PrologList;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import java.util.Map;

public class ParserUtils {
    public static Pair<Term, Integer> parseTerm(char[] c, int start, char endCharacter, Map<Variable, Variable> variables, Map<Constant, Constant> constants) {
        int index;
        StringBuilder term = new StringBuilder();
        int roundBrackets = 0;
        int rectBrackets = 0;
        boolean CONSTANT_OR_VARIABLE = true;
        int FUNCTION = 2;
        int LIST = 3;
        int type = 1;
        boolean ignoreNext = false;
        boolean inQuotes = false;
        boolean inDoubleQuotes = false;
        Term retVal = null;
        for (index = start; index < c.length && c[index] == ' '; ++index) {
        }
        int tStart = index;
        while (index < c.length) {
            if (c[index] == '\\' && !ignoreNext) {
                ignoreNext = true;
            } else {
                if (!(inQuotes || inDoubleQuotes || c[index] != '\'' || ignoreNext)) {
                    term.append(c[index]);
                    inQuotes = true;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '\"' || ignoreNext)) {
                    term.append(c[index]);
                    inDoubleQuotes = true;
                } else if (inQuotes && c[index] == '\'' && !ignoreNext) {
                    term.append(c[index]);
                    inQuotes = false;
                } else if (inDoubleQuotes && c[index] == '\"' && !ignoreNext) {
                    term.append(c[index]);
                    inDoubleQuotes = false;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '[' || ignoreNext)) {
                    if (type == 1 && index == tStart) {
                        type = 3;
                    }
                    term.append(c[index]);
                    ++rectBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != ']' || rectBrackets <= 0 || ignoreNext)) {
                    term.append(c[index]);
                    --rectBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != '(' || ignoreNext)) {
                    if (type == 1) {
                        type = 2;
                    }
                    term.append(c[index]);
                    ++roundBrackets;
                } else if (!(inQuotes || inDoubleQuotes || c[index] != ')' || roundBrackets <= 0 || ignoreNext)) {
                    term.append(c[index]);
                    --roundBrackets;
                } else {
                    if (!inQuotes && !inDoubleQuotes && roundBrackets == 0 && rectBrackets == 0 && (c[index] == endCharacter && index == c.length - 1 || c[index] == ',')) break;
                    if (!Character.isSpaceChar(c[index])) {
                        term.append(c[index]);
                    }
                }
                ignoreNext = false;
            }
            ++index;
        }
        String termString = term.toString().trim();
        switch (type) {
            case 1: {
                int typeBreak = -1;
                int i = 0;
                for (char ch : termString.toCharArray()) {
                    if (ch == ':') {
                        typeBreak = i;
                        break;
                    }
                    if (!Character.isLetterOrDigit(ch)) break;
                    ++i;
                }
                String typeString = null;
                if (typeBreak != -1) {
                    typeString = termString.substring(0, typeBreak);
                    termString = termString.substring(typeBreak + 1);
                }
                if (termString.length() == 0) {
                    retVal = Constant.construct("", typeString);
                    break;
                }
                if (Character.isUpperCase(termString.charAt(0)) || termString.charAt(0) == '_') {
                    Variable var = Variable.construct(termString, typeString);
                    retVal = variables.get(var);
                    if (retVal != null) break;
                    variables.put(var, var);
                    retVal = var;
                    break;
                }
                Constant constant = Constant.construct(termString, typeString);
                retVal = constants.get(constant);
                if (retVal != null) break;
                constants.put(constant, constant);
                retVal = constant;
                break;
            }
            case 3: {
                PrologList list;
                retVal = list = PrologList.parseList(termString, variables, constants);
                break;
            }
            case 2: {
                Function f = Function.parseFunction(termString, variables, constants);
                retVal = f;
            }
        }
        return new Pair<Object, Integer>(retVal, index);
    }

    public static void main(String[] args) {
        System.out.println(Literal.parseLiteral("pred(X , Y)"));
    }
}

