/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building;

import cz.cvut.fel.ida.algebra.values.ScalarValue;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.building.SamplesBuilder;
import cz.cvut.fel.ida.logic.constructs.example.LogicSample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.parsing.antlr.NeuralogicParser;
import cz.cvut.fel.ida.logic.parsing.grammarParsing.PlainGrammarVisitor;
import cz.cvut.fel.ida.logic.parsing.queries.PlainQueriesParseTree;
import cz.cvut.fel.ida.logic.parsing.queries.PlainQueriesParseTreeExtractor;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class QueriesBuilder
extends SamplesBuilder<PlainQueriesParseTree, Pair<ValuedFact, Conjunction>> {
    private static final Logger LOG = Logger.getLogger(QueriesBuilder.class.getName());

    public QueriesBuilder(Settings settings) {
        super(settings);
    }

    @Override
    public PlainQueriesParseTree parseTreeFrom(Reader reader) {
        try {
            return new PlainQueriesParseTree(reader);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Stream<Pair<ValuedFact, Conjunction>> buildFrom(PlainQueriesParseTree parseTree) {
        PlainGrammarVisitor plainGrammarVisitor = new PlainGrammarVisitor(this);
        PlainQueriesParseTreeExtractor queriesParseTreeExtractor = new PlainQueriesParseTreeExtractor(plainGrammarVisitor);
        NeuralogicParser.QueriesFileContext queriesFileContext = parseTree.getRoot();
        this.inferInputFormatSettings(queriesFileContext);
        return queriesParseTreeExtractor.getLabeledQueries(queriesFileContext);
    }

    @Override
    public Stream<LogicSample> sampleFrom(Pair<ValuedFact, Conjunction> pair) {
        if (((Conjunction)pair.s).facts == null || ((Conjunction)pair.s).facts.size() == 0) {
            LOG.severe("Cannot extract LogicSample(s) without a query provided!");
            return Stream.empty();
        }
        Stream queries = ((Conjunction)pair.s).facts.stream();
        if (pair.r != null) {
            String id = ((ValuedFact)pair.r).literal.toString();
            if (((ValuedFact)pair.r).getValue() != null) {
                if (((ValuedFact)pair.r).getValue() instanceof ScalarValue) {
                    double importance = ((ScalarValue)((ValuedFact)pair.r).getValue()).value;
                    return queries.map(f -> new LogicSample(f.getValue(), this.createQueryAtom(id, importance, (ValuedFact)f), true));
                }
                if (((ValuedFact)pair.r).getValue() != Value.ONE) {
                    LOG.warning("Query with non-scalar target value not supported (yet)");
                }
                return queries.map(f -> new LogicSample(f.getValue(), this.createQueryAtom(id, (ValuedFact)f), true));
            }
            return queries.map(f -> new LogicSample(f.getValue(), this.createQueryAtom(id, (ValuedFact)f), true));
        }
        String minibatch = String.valueOf(this.queryCounter);
        return queries.map(f -> new LogicSample(f.getValue(), this.createQueryAtom(minibatch, (ValuedFact)f), true));
    }

    private void inferInputFormatSettings(NeuralogicParser.QueriesFileContext queriesFileContext) {
        int size;
        if (queriesFileContext.atom() != null && !queriesFileContext.atom().isEmpty()) {
            LOG.info("Detecting queries to have Ids (to examples) with them!");
        }
        if ((size = queriesFileContext.conjunction().size()) == 0) {
            LOG.warning("There are no queries in the queries source (file)!");
        } else if (size == 1) {
            LOG.warning("There is only 1 query to learn from!");
        } else {
            LOG.info("Detecting multiple independent queries (standard supervised learning).");
        }
        if (queriesFileContext.conjunction(0).atom().size() > 1) {
            LOG.info("Detecting multiple individual queries per example.");
            this.settings.oneQueryPerExample = false;
        } else {
            LOG.info("Heuristically detecting atomic queries (=no batch queries)");
            this.settings.oneQueryPerExample = true;
        }
    }
}

