/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building.factories;

import cz.cvut.fel.ida.logic.Constant;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class ConstantFactory {
    private static final Logger LOG = Logger.getLogger(ConstantFactory.class.getName());
    private Map<String, Constant> str2const;
    private Map<Constant, Constant> const2const;

    public ConstantFactory() {
        this.str2const = new HashMap<String, Constant>();
        this.const2const = new HashMap<Constant, Constant>();
    }

    public ConstantFactory(Collection<Constant> vars) {
        this.str2const = vars.stream().collect(Collectors.toMap(Constant::toString, Function.identity()));
        this.const2const = vars.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    public Constant construct(String from) {
        Constant result = this.str2const.get(from);
        if (result == null) {
            result = Constant.construct(from);
            this.str2const.put(from, result);
            this.const2const.put(result, result);
        }
        return result;
    }

    public Constant construct(Constant from) {
        Constant result = this.const2const.get(from);
        if (result == null) {
            this.str2const.put(result.toString(), result);
            this.const2const.put(result, result);
        }
        return from;
    }
}

