/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.building.factories;

import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class WeightedPredicateFactory {
    private static final Logger LOG = Logger.getLogger(WeightedPredicateFactory.class.getName());
    private Map<String, WeightedPredicate> str2pred;
    private Map<WeightedPredicate, WeightedPredicate> pred2pred;

    public WeightedPredicateFactory() {
        this.str2pred = new HashMap<String, WeightedPredicate>();
        this.pred2pred = new HashMap<WeightedPredicate, WeightedPredicate>();
    }

    public WeightedPredicateFactory(Collection<WeightedPredicate> preds) {
        this.str2pred = preds.stream().collect(Collectors.toMap(WeightedPredicate::toString, Function.identity()));
        this.pred2pred = preds.stream().collect(Collectors.toMap(Function.identity(), Function.identity()));
    }

    public WeightedPredicate construct(String from, int arity, Boolean special) {
        WeightedPredicate result = this.str2pred.get(from + "/" + arity);
        if (result == null) {
            result = WeightedPredicate.construct(from, arity, special);
            this.str2pred.put(from + "/" + arity, result);
            this.pred2pred.put(result, result);
        }
        return result;
    }

    public WeightedPredicate construct(WeightedPredicate from) {
        if (this.pred2pred.containsKey(from)) {
            return this.pred2pred.get(from);
        }
        this.str2pred.put(from.predicate.name + "/" + from.predicate.arity, from);
        this.pred2pred.put(from, from);
        return from;
    }

    public int addOffsets(List<Pair<WeightedPredicate, Weight>> predicateOffsetsList) {
        int changes = 0;
        for (Pair<WeightedPredicate, Weight> predicateWeightPair : predicateOffsetsList) {
            this.pred2pred.get((Object)predicateWeightPair.r).weight = (Weight)predicateWeightPair.s;
            ++changes;
        }
        return changes;
    }

    public WeightedPredicate construct(String name, int arity) {
        return this.construct(name, arity, null);
    }
}

