/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template;

import com.sun.istack.internal.Nullable;
import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.learning.Model;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.constructs.Atom;
import cz.cvut.fel.ida.logic.constructs.Conjunction;
import cz.cvut.fel.ida.logic.constructs.example.QueryAtom;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.types.GraphTemplate;
import cz.cvut.fel.ida.logic.subsumption.HerbrandModel;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Template
implements Model<QueryAtom>,
Exportable {
    private static final Logger LOG = Logger.getLogger(Template.class.getName());
    static int counter = 0;
    protected String name;
    public LinkedHashSet<WeightedRule> rules;
    public LinkedHashSet<ValuedFact> facts;
    public LinkedHashSet<Conjunction> constraints;
    @Nullable
    transient Set<Literal> inferredLiterals;
    @Nullable
    public transient Map<HornClause, List<WeightedRule>> hornClauses;

    public Template() {
        this.name = "template" + counter++;
        this.rules = new LinkedHashSet();
        this.facts = new LinkedHashSet();
        this.constraints = new LinkedHashSet();
    }

    public Template(Template other) {
        this.rules = other.rules;
        this.facts = other.facts;
        this.constraints = other.constraints;
    }

    public Template(List<WeightedRule> rules, List<ValuedFact> facts) {
        this();
        this.rules.addAll(rules);
        this.facts.addAll(facts);
    }

    public void addConstraints(List<Conjunction> constr) {
        this.constraints = new LinkedHashSet<Conjunction>(constr);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Value evaluate(QueryAtom query) {
        return null;
    }

    @Override
    public List<Weight> getAllWeights() {
        ArrayList<Weight> weightList = new ArrayList<Weight>();
        for (WeightedRule rule : this.rules) {
            Weight headOffset;
            Weight offset;
            if (rule.getWeight() != null) {
                weightList.add(rule.getWeight());
            }
            if ((offset = rule.getOffset()) != null) {
                offset.isOffset = true;
                weightList.add(offset);
            }
            if ((headOffset = rule.getHead().getOffset()) != null) {
                headOffset.isOffset = true;
                weightList.add(headOffset);
            }
            for (BodyAtom bodyAtom : rule.getBody()) {
                if (bodyAtom.getConjunctWeight() == null) continue;
                weightList.add(bodyAtom.getConjunctWeight());
            }
        }
        List<Weight> uniqueWeights = this.filterUnique(weightList);
        return uniqueWeights;
    }

    private List<Weight> filterUnique(List<Weight> weightList) {
        return weightList.stream().distinct().collect(Collectors.toList());
    }

    public void updateWeightsFrom(Map<Integer, Weight> neuralWeights) {
        List<Weight> templateWeights = this.getAllWeights();
        for (Weight weight : templateWeights) {
            if (!weight.isLearnable()) continue;
            weight.value = neuralWeights.get((Object)Integer.valueOf((int)weight.index)).value;
        }
    }

    public LinkedHashSet<ValuedFact> getValuedFacts() {
        return this.facts;
    }

    public Set<Literal> getAllFacts() {
        if (this.inferredLiterals == null) {
            this.inferredLiterals = this.inferTemplateFacts();
            if (this.inferredLiterals != null) {
                this.inferredLiterals.addAll(this.facts.stream().map(Atom::getLiteral).collect(Collectors.toList()));
            }
        }
        return this.inferredLiterals;
    }

    public void setFacts(LinkedHashSet<ValuedFact> facts) {
        this.facts = facts;
    }

    public Set<Literal> inferTemplateFacts() {
        if (this.facts == null || this.facts.isEmpty()) {
            return null;
        }
        if (this.inferredLiterals == null) {
            this.inferredLiterals = new HashSet<Literal>();
        }
        HerbrandModel herbrandModel = new HerbrandModel();
        Set<Literal> facts = this.facts.stream().map(Atom::getLiteral).collect(Collectors.toSet());
        Set<HornClause> rules = this.rules.stream().map(WeightedRule::toHornClause).collect(Collectors.toSet());
        Collection<Literal> values = herbrandModel.inferLiterals(rules, facts);
        this.inferredLiterals.addAll(values);
        return this.inferredLiterals;
    }

    public GraphTemplate prune(QueryAtom query) {
        LOG.warning("Inefficient template pruning");
        return new GraphTemplate(this).prune(query);
    }

    public void addAllFrom(Template template) {
        if (template == this) {
            return;
        }
        this.rules.addAll(template.rules);
        this.facts.addAll(template.facts);
        this.constraints.addAll(template.constraints);
    }

    public String toString() {
        return this.name + ", rules: " + this.rules.size() + ", facts: " + this.facts.size() + ", constraints: " + this.constraints.size();
    }
}

