/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.constructs.template.transforming;

import cz.cvut.fel.ida.algebra.utils.metadata.Metadata;
import cz.cvut.fel.ida.algebra.utils.metadata.WeightMetadata;
import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.logic.constructs.WeightedPredicate;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.metadata.PredicateMetadata;
import cz.cvut.fel.ida.logic.constructs.template.types.ParsedTemplate;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.io.Serializable;
import java.util.logging.Logger;

public class MetadataProcessor {
    private static final Logger LOG = Logger.getLogger(MetadataProcessor.class.getName());

    public MetadataProcessor(Settings settings) {
    }

    public ParsedTemplate processMetadata(ParsedTemplate template) {
        for (Pair<WeightedPredicate, PredicateMetadata> pair : template.predicatesMetadata) {
            if (((WeightedPredicate)pair.r).metadata == null) {
                ((WeightedPredicate)pair.r).metadata = (PredicateMetadata)pair.s;
            } else {
                ((WeightedPredicate)pair.r).metadata.addAll((PredicateMetadata)pair.s);
            }
            ((WeightedPredicate)pair.r).metadata.applyTo((WeightedPredicate)pair.r);
        }
        for (Pair<Serializable, Metadata> pair : template.weightsMetadata) {
            if (((Weight)pair.r).metadata == null) {
                ((Weight)pair.r).metadata = (WeightMetadata)pair.s;
            } else {
                ((Weight)pair.r).metadata.addAll((WeightMetadata)pair.s);
            }
            ((WeightMetadata)pair.s).applyTo((Weight)pair.r);
        }
        for (WeightedRule weightedRule : template.rules) {
            if (weightedRule.getMetadata() == null) continue;
            weightedRule.getMetadata().applyTo(weightedRule);
        }
        if (template.templateMetadata != null) {
            template.templateMetadata.applyTo(template);
        }
        return template;
    }
}

