/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.grounding.bottomUp;

import com.sun.istack.internal.NotNull;
import cz.cvut.fel.ida.logic.HornClause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.logic.constructs.example.LiftedExample;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundHeadRule;
import cz.cvut.fel.ida.logic.constructs.template.components.GroundRule;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.grounding.GroundTemplate;
import cz.cvut.fel.ida.logic.grounding.Grounder;
import cz.cvut.fel.ida.logic.subsumption.HerbrandModel;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BottomUp
extends Grounder {
    private static final Logger LOG = Logger.getLogger(BottomUp.class.getName());
    transient HerbrandModel herbrandModel = new HerbrandModel();
    long herbrandCumSize = 0L;
    int totalRules = 0;
    long totalGroundRules = 0L;

    public BottomUp(Settings settings) {
        super(settings);
    }

    @Override
    @NotNull
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template) {
        Set<Literal> templateAllFacts;
        this.timing.tic();
        Map ruleMap = template.hornClauses;
        Map groundFacts = null;
        if (example.rules.isEmpty() && ruleMap != null) {
            groundFacts = this.mapToLogic((Set)this.rulesAndFacts((LiftedExample)example, (Template)template).s);
        } else {
            Pair<Map<HornClause, List<WeightedRule>>, Map<Literal, ValuedFact>> rulesAndFacts = this.mapToLogic(this.rulesAndFacts(example, template));
            ruleMap = (Map)rulesAndFacts.r;
            groundFacts = (Map)rulesAndFacts.s;
            template.hornClauses = ruleMap;
        }
        LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>> groundRules = new LinkedHashMap<Literal, LinkedHashMap<GroundHeadRule, LinkedHashSet<GroundRule>>>();
        Set<Literal> facts = groundFacts.keySet();
        if (this.settings.inferTemplateFacts && (templateAllFacts = template.getAllFacts()) != null) {
            facts.addAll(templateAllFacts);
        }
        LOG.fine("Infering Herbrand model...");
        Collection<Literal> literals = this.herbrandModel.inferLiterals(ruleMap.keySet(), facts);
        Map<Literal, Literal> allLiterals = literals.stream().collect(Collectors.toMap(l -> l, l -> l));
        LOG.fine("...HerbrandModel inferred with " + allLiterals.size() + " facts");
        this.herbrandCumSize += (long)allLiterals.size();
        LOG.fine("Grounding of " + ruleMap.size() + " rules...");
        this.totalRules += ruleMap.size();
        for (Map.Entry ruleEntry : ruleMap.entrySet()) {
            Pair<Term[], List<Term[]>> groundingSubstitutions = this.herbrandModel.groundingSubstitutions((HornClause)ruleEntry.getKey());
            for (WeightedRule weightedRule : (List)ruleEntry.getValue()) {
                List<GroundRule> groundings = this.groundRules(weightedRule, groundingSubstitutions);
                for (GroundRule grounding : groundings) {
                    grounding.internLiterals(allLiterals);
                    Map rules2groundings = groundRules.computeIfAbsent(grounding.groundHead, k -> new LinkedHashMap());
                    GroundHeadRule groundHeadRule = weightedRule.groundHeadRule(grounding.groundHead);
                    LinkedHashSet ruleGroundings = rules2groundings.computeIfAbsent(groundHeadRule, k -> new LinkedHashSet());
                    ruleGroundings.add(grounding);
                }
            }
        }
        LOG.fine(groundRules.size() + " ground rules created.");
        this.totalGroundRules += (long)groundRules.size();
        GroundTemplate groundTemplate = new GroundTemplate(groundRules, groundFacts);
        this.herbrandModel.clear();
        this.timing.toc();
        return groundTemplate;
    }

    @Override
    public GroundTemplate groundRulesAndFacts(LiftedExample example, Template template, GroundTemplate memory) {
        if (memory == null) {
            memory = new GroundTemplate();
        }
        this.herbrandModel.populateHerbrand(memory.groundFacts.keySet());
        this.herbrandModel.populateHerbrand(memory.derivedGroundFacts);
        GroundTemplate bigger = this.groundRulesAndFacts(example, template);
        GroundTemplate diff = bigger.diffAgainst(memory);
        memory.groundRules = bigger.groundRules;
        memory.groundFacts = bigger.groundFacts;
        memory.derivedGroundFacts = bigger.derivedGroundFacts;
        return diff;
    }

    public List<GroundRule> groundRules(HerbrandModel herbrandModel, WeightedRule liftedRule) {
        return this.groundRules(herbrandModel, liftedRule, liftedRule.toHornClause());
    }

    public List<GroundRule> groundRules(HerbrandModel herbrandModel, WeightedRule liftedRule, HornClause hc) {
        Pair<Term[], List<Term[]>> substitutions = herbrandModel.groundingSubstitutions(hc);
        return this.groundRules(liftedRule, substitutions);
    }

    public List<GroundRule> groundRules(WeightedRule liftedRule, Pair<Term[], List<Term[]>> substitutions) {
        ArrayList<GroundRule> groundRules = new ArrayList<GroundRule>();
        for (int i = 0; i < ((List)substitutions.s).size(); ++i) {
            GroundRule groundRule = liftedRule.groundRule((Term[])((List)substitutions.s).get(i));
            groundRules.add(groundRule);
        }
        return groundRules;
    }
}

