/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.special;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Variable;
import cz.cvut.fel.ida.logic.subsumption.Matching;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.collections.Counters;
import cz.cvut.fel.ida.utils.math.collections.MultiMap;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IsoClauseWrapper {
    private Clause originalClause;
    private Clause enrichedClause;
    public static BigInteger HASH_MOD = BigInteger.ONE.shiftLeft(32);
    private int hashCode;

    public IsoClauseWrapper(Clause clause) {
        this.originalClause = clause;
        this.enrichedClause = IsoClauseWrapper.preprocess(clause);
        this.hashCode = IsoClauseWrapper.computeHashCode(this.enrichedClause);
    }

    public IsoClauseWrapper(Collection<Literal> literals) {
        this(new Clause(literals));
    }

    private static int computeHashCode(Clause c) {
        ArrayList<String> strs = new ArrayList<String>();
        for (Literal l : c.literals()) {
            strs.add(l.predicateName());
        }
        Collections.sort(strs);
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str).append("@");
        }
        return IsoClauseWrapper.hash(sb.toString()).hashCode();
    }

    private static Clause preprocess(Clause clause) {
        HashSet newLiterals = new HashSet();
        Set<Literal> preprocessedLiterals = IsoClauseWrapper.transformLiterals(clause.literals());
        Set<Literal> fingerPrints = IsoClauseWrapper.initialFingerPrints(clause.literals());
        List<Integer> oldUnique = null;
        List<Integer> unique = IsoClauseWrapper.uniquenessSpectrum(fingerPrints);
        do {
            oldUnique = unique;
            Set<Literal> newFingerprints = IsoClauseWrapper.extendFingerprints(preprocessedLiterals, fingerPrints);
            unique = IsoClauseWrapper.uniquenessSpectrum(newFingerprints);
            fingerPrints = newFingerprints;
        } while (!oldUnique.equals(unique));
        return new Clause(Sugar.iterable(preprocessedLiterals, fingerPrints));
    }

    private static List<Integer> uniquenessSpectrum(Set<Literal> fingerPrints) {
        Counters<String> counters = new Counters<String>();
        for (Literal l : fingerPrints) {
            counters.increment(l.predicateName());
        }
        List<Integer> counts = Sugar.listFromCollections(counters.counts());
        Collections.sort(counts);
        return counts;
    }

    private static Set<Literal> transformLiterals(Set<Literal> literals) {
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (Literal l : literals) {
            int numVariables = 0;
            StringBuilder pred = new StringBuilder("~");
            if (l.isNegated()) {
                pred.append("!");
            }
            for (int i = 0; i < l.arity(); ++i) {
                if (l.get(i) instanceof Variable) {
                    ++numVariables;
                    continue;
                }
                pred.append(l.get(i)).append("@").append(i).append("@");
            }
            pred.append(l.predicateName());
            Literal newLiteral = new Literal(pred.toString(), numVariables);
            int j = 0;
            for (int i = 0; i < l.arity(); ++i) {
                if (!(l.get(i) instanceof Variable)) continue;
                newLiteral.set(l.get(i), j++);
            }
            retVal.add(newLiteral);
        }
        return retVal;
    }

    private static MultiMap<Variable, Variable> buildNeighbourhoods(Set<Literal> literals) {
        MultiMap<Variable, Variable> neighbours = new MultiMap<Variable, Variable>();
        for (Literal l : literals) {
            for (int i = 0; i < l.arity(); ++i) {
                if (!(l.get(i) instanceof Variable)) continue;
                for (int j = 0; j < l.arity(); ++j) {
                    if (i == j || !(l.get(j) instanceof Variable)) continue;
                    neighbours.put((Variable)l.get(i), (Variable)l.get(j));
                }
            }
        }
        return neighbours;
    }

    private static Set<Literal> initialFingerPrints(Set<Literal> literals) {
        Clause orig = new Clause(literals);
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (Variable v : orig.variables()) {
            ArrayList<String> inLitSignatures = new ArrayList<String>();
            for (Literal l : orig.getLiteralsByTerm(v)) {
                StringBuilder sb = new StringBuilder();
                sb.append(l.predicateName()).append("@").append(l.arity()).append("@");
                for (int i = 0; i < l.arity(); ++i) {
                    if (!l.get(i).equals(v)) continue;
                    sb.append(i).append("@");
                }
                inLitSignatures.add(sb.toString());
            }
            Collections.sort(inLitSignatures);
            StringBuilder sb = new StringBuilder();
            for (String s : inLitSignatures) {
                sb.append(s).append("@");
            }
            retVal.add(new Literal(IsoClauseWrapper.hash(sb.toString()), v));
        }
        return retVal;
    }

    private static Set<Literal> extendFingerprints(Set<Literal> literals, Set<Literal> fingerprints) {
        HashMap<Variable, Literal> fpsMap = new HashMap<Variable, Literal>();
        MultiMap<Variable, Variable> neighbours = IsoClauseWrapper.buildNeighbourhoods(literals);
        for (Literal l : fingerprints) {
            fpsMap.put((Variable)l.get(0), l);
        }
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (Literal l : fingerprints) {
            ArrayList<String> neighbourFps = new ArrayList<String>();
            Variable v = (Variable)l.get(0);
            for (Variable neighbour : neighbours.get(v)) {
                String fp = ((Literal)fpsMap.get(neighbour)).predicateName();
                neighbourFps.add(fp);
            }
            Collections.sort(neighbourFps);
            StringBuilder sb = new StringBuilder();
            for (String neighbourFp : neighbourFps) {
                sb.append(neighbourFp);
            }
            sb.append(((Literal)fpsMap.get(v)).predicateName());
            retVal.add(new Literal(IsoClauseWrapper.hash(sb.toString()), v));
        }
        return retVal;
    }

    private static String hash(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(str.getBytes());
            return new BigInteger(1, messageDigest.digest()).mod(HASH_MOD).toString(16);
        }
        catch (NoSuchAlgorithmException nsae) {
            return String.valueOf(str.hashCode());
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o instanceof IsoClauseWrapper) {
            long m1 = System.nanoTime();
            IsoClauseWrapper icw = (IsoClauseWrapper)o;
            if (icw.hashCode() != this.hashCode() || icw.originalClause.countLiterals() != this.originalClause.countLiterals() || !icw.enrichedClause.predicates().equals(this.enrichedClause.predicates()) || icw.originalClause.variables().size() != this.originalClause.variables().size()) {
                return false;
            }
            if (icw.originalClause.literals().equals(this.originalClause.literals())) {
                return true;
            }
            Matching m = new Matching();
            m.setSubsumptionMode(2);
            boolean result = m.subsumption(icw.enrichedClause, this.enrichedClause);
            return result;
        }
        return false;
    }

    public Clause getOriginalClause() {
        return this.originalClause;
    }

    public String toString() {
        return this.enrichedClause.toString();
    }

    public static void main(String[] args) {
        Clause c = Clause.parse("!b(Y,Z), b(Z,W), b(W,Y), b(W,A), c(x,y)");
        Clause d = Clause.parse("!b(Y,Z), b(Z,W), b(W,Y), b(W,A)");
        IsoClauseWrapper icw = new IsoClauseWrapper(c);
        System.out.println(icw.enrichedClause);
        System.out.println(c.equals(d));
    }
}

