/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.logic.subsumption;

import cz.cvut.fel.ida.logic.Clause;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.Term;
import cz.cvut.fel.ida.utils.generic.tuples.Pair;
import cz.cvut.fel.ida.utils.math.Sugar;
import cz.cvut.fel.ida.utils.math.VectorUtils;
import cz.cvut.fel.ida.utils.math.collections.Counters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SubsumptionUtils {
    public static Set<Literal> neighbours(Literal l, Clause c) {
        HashSet<Literal> retVal = new HashSet<Literal>();
        for (int i = 0; i < l.arity(); ++i) {
            for (Literal neighb : c.getLiteralsByTerm(l.get(i))) {
                if (l.equals(neighb)) continue;
                retVal.add(neighb);
            }
        }
        return retVal;
    }

    public static Pair<Clause, List<Pair<Literal, Literal>>> gyoDecomposition(Clause c) {
        ArrayList<Pair<Object, Literal>> joins = new ArrayList<Pair<Object, Literal>>();
        HashMap<Literal, boolean[]> hypergraph = new HashMap<Literal, boolean[]>();
        HashMap<Literal, Object> suspected = new HashMap<Literal, Object>();
        Counters<Term> counters = new Counters<Term>();
        for (Literal l : c.literals()) {
            hypergraph.put(l, VectorUtils.trues(l.arity()));
            suspected.put(l, VectorUtils.trues(l.arity()));
            for (Term t : l.terms()) {
                counters.increment(t);
            }
        }
        HashSet<Object> used = new HashSet<Object>();
        block2: while (suspected.size() > 0) {
            Map.Entry s = Sugar.removeOne(suspected);
            for (int i = 0; i < ((Literal)s.getKey()).arity(); ++i) {
                if (counters.get(((Literal)s.getKey()).get(i)) != 1) continue;
                ((boolean[])s.getValue())[i] = false;
            }
            HashSet<Literal> neighbours = new HashSet<Literal>();
            for (int i = 0; i < ((Literal)s.getKey()).arity(); ++i) {
                neighbours.addAll(c.getLiteralsByTerm(((Literal)s.getKey()).get(i)));
            }
            for (Literal testLiteral : neighbours) {
                if (((Literal)s.getKey()).equals(testLiteral) || used.contains(testLiteral) || !SubsumptionUtils.aIsInB((Literal)s.getKey(), testLiteral, (boolean[])s.getValue())) continue;
                used.add(s.getKey());
                joins.add(new Pair(s.getKey(), testLiteral));
                for (Term t : SubsumptionUtils.commonTerms((Literal)s.getKey(), testLiteral, (boolean[])s.getValue())) {
                    if (counters.decrementPre(t) != 1) continue;
                    suspected.put(testLiteral, hypergraph.get(testLiteral));
                }
                continue block2;
            }
        }
        if (used.size() == c.countLiterals() - 1) {
            Literal root = null;
            for (Literal l : c.literals()) {
                if (used.contains(l)) continue;
                root = l;
                break;
            }
            used.add(root);
            joins.add(new Pair<Literal, Object>(root, null));
        }
        return new Pair<Clause, List<Pair<Literal, Literal>>>(new Clause(Sugar.collectionDifference(c.literals(), used)), joins);
    }

    public static List<Pair<Literal, Literal>> gyo(Clause c) {
        ArrayList<Pair<Literal, Literal>> joins = new ArrayList<Pair<Literal, Literal>>();
        HashMap<Literal, boolean[]> hypergraph = new HashMap<Literal, boolean[]>();
        HashMap<Literal, Object> suspected = new HashMap<Literal, Object>();
        Counters<Term> counters = new Counters<Term>();
        for (Literal l : c.literals()) {
            hypergraph.put(l, VectorUtils.trues(l.arity()));
            suspected.put(l, VectorUtils.trues(l.arity()));
            for (Term t : l.terms()) {
                counters.increment(t);
            }
        }
        HashSet used = new HashSet();
        block2: while (suspected.size() > 0) {
            Map.Entry s = Sugar.removeOne(suspected);
            for (int i = 0; i < ((Literal)s.getKey()).arity(); ++i) {
                if (counters.get(((Literal)s.getKey()).get(i)) != 1) continue;
                ((boolean[])s.getValue())[i] = false;
            }
            HashSet<Literal> neighbours = new HashSet<Literal>();
            for (int i = 0; i < ((Literal)s.getKey()).arity(); ++i) {
                neighbours.addAll(c.getLiteralsByTerm(((Literal)s.getKey()).get(i)));
            }
            for (Literal testLiteral : neighbours) {
                if (((Literal)s.getKey()).equals(testLiteral) || used.contains(testLiteral) || !SubsumptionUtils.aIsInB((Literal)s.getKey(), testLiteral, (boolean[])s.getValue())) continue;
                used.add(s.getKey());
                joins.add(new Pair(s.getKey(), testLiteral));
                for (Term t : SubsumptionUtils.commonTerms((Literal)s.getKey(), testLiteral, (boolean[])s.getValue())) {
                    if (counters.decrementPre(t) != 1) continue;
                    suspected.put(testLiteral, hypergraph.get(testLiteral));
                }
                continue block2;
            }
        }
        if (used.size() < c.countLiterals() - 1) {
            return null;
        }
        return joins;
    }

    private static Set<Term> commonTerms(Literal a, Literal b, boolean[] maskA) {
        HashSet<Term> setA = new HashSet<Term>();
        Set<Term> setB = b.terms();
        for (int i = 0; i < a.arity(); ++i) {
            if (!maskA[i] || !setB.contains(a.get(i))) continue;
            setA.add(a.get(i));
        }
        return setA;
    }

    private static boolean aIsInB(Literal a, Literal b, boolean[] maskA) {
        HashSet<Term> setA = new HashSet<Term>();
        for (int i = 0; i < a.arity(); ++i) {
            if (!maskA[i]) continue;
            setA.add(a.get(i));
        }
        return Sugar.isSubsetOf(setA, b.terms());
    }
}

