/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.computation.iteration.visitors.states;

import cz.cvut.fel.ida.algebra.values.Value;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import java.util.logging.Logger;

public abstract class StateVisiting<V> {
    private static final Logger LOG = Logger.getLogger(StateVisiting.class.getName());

    public abstract V visit(State<V> var1);

    public static abstract class Structure<V>
    extends StateVisiting<V> {
        @Override
        public V visit(State<V> state) {
            LOG.severe("StructureVisitor called for generic State<Structure>.");
            return state.accept(this);
        }
    }

    public static abstract class Computation
    extends StateVisiting<Value> {
        public int stateIndex;

        protected Computation() {
            this.stateIndex = -1;
        }

        public Computation(int stateIndex) {
            this.stateIndex = stateIndex;
        }

        @Override
        public Value visit(State<Value> state) {
            LOG.severe("Default double dispatch - computationVisitor called for generic State<Value>.");
            return this.visit((State.Neural.Computation)state);
        }

        public abstract Value visit(State.Neural.Computation var1);

        public static abstract class Detailed
        extends Computation {
            public Detailed(int stateIndex) {
                super(stateIndex);
            }

            public abstract Value visit(State.Neural.Computation.HasParents var1);

            public abstract Value visit(State.Neural.Computation.HasDropout var1);

            public abstract Value visit(State.Neural.Computation.Detailed var1);
        }
    }
}

