/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings;

import cz.cvut.fel.ida.algebra.weights.Weight;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.Neurons;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.LinkedMapping;
import cz.cvut.fel.ida.neural.networks.structure.metadata.inputMappings.NeuronMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class WeightedNeuronMapping<T extends Neurons>
extends NeuronMapping<T>
implements LinkedMapping.WeightMapping {
    private static final Logger LOG = Logger.getLogger(WeightedNeuronMapping.class.getName());
    List<Weight> weights;
    public WeightedNeuronMapping<T> previous;

    public WeightedNeuronMapping(List<T> inputs, List<Weight> weights) {
        super(inputs);
        this.previous = new WeightedNeuronMapping<T>();
        this.previous.weights = new ArrayList<Weight>(weights);
        this.weights = new ArrayList<Weight>();
    }

    public WeightedNeuronMapping(WeightedNeuronMapping<T> previous) {
        super(previous);
        this.previous = previous;
        this.weights = new ArrayList<Weight>();
    }

    public WeightedNeuronMapping() {
        this.weights = new ArrayList<Weight>();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public Iterator<Weight> weightIterator() {
        return new WeightIterator(this);
    }

    @Override
    public void addWeight(Weight weight) {
        this.weights.add(weight);
    }

    public class WeightIterator
    implements Iterator<Weight> {
        WeightedNeuronMapping<T> actual;
        int current;

        public WeightIterator(WeightedNeuronMapping<T> inputMapping) {
            this.actual = inputMapping;
            this.current = this.actual.inputs.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.actual.previous != null || this.current > 0;
        }

        @Override
        public Weight next() {
            if (this.current >= 0) {
                return this.actual.weights.get(this.current--);
            }
            if (this.actual.previous != null) {
                this.actual = this.actual.previous;
                this.current = this.actual.inputs.size() - 1;
                return this.actual.weights.get(this.current--);
            }
            return null;
        }

        public void replace(Weight weight) {
            this.actual.weights.set(this.current + 1, weight);
        }
    }
}

