/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines;

import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.exporting.Exporter;
import cz.cvut.fel.ida.utils.generic.Timing;
import java.util.logging.Logger;

public abstract class Block {
    private static final Logger LOG = Logger.getLogger(Block.class.getName());
    public String ID;
    protected Pipeline parent;
    public Exporter exporter;
    public Settings settings;

    protected Block(String id, Settings settings) {
        this.settings = settings;
        this.ID = id;
        this.exporter = Block.createExporter(id, settings);
    }

    protected Block() {
    }

    public Pipeline getRoot() {
        Pipeline par = this.parent;
        while (par.parent != null) {
            par = par.parent;
        }
        return par;
    }

    public static Exporter createExporter(String id, Settings settings) {
        if (settings == null) {
            return null;
        }
        return Exporter.getFrom(settings.exportDir, id, settings.exportBlocks, settings.exportType.name());
    }

    protected <T> void export(T outputReady) {
        if (outputReady instanceof Exportable) {
            if (this.exporter == null && this.parent != null) {
                this.exporter = Block.createExporter(this.ID, this.settings);
            }
            if (this.exporter != null) {
                ((Exportable)outputReady).export(this.exporter);
            }
        }
    }

    protected <T> void export(T outputReady, Timing timing) {
        PipelineTiming<T> pipelineTiming = new PipelineTiming<T>(outputReady, timing);
        this.export(pipelineTiming);
    }

    public String toString() {
        return this.ID;
    }

    private class PipelineTiming<T>
    implements Exportable {
        T pipelineOutput;
        Timing timing;

        public PipelineTiming(T pipelineOutput, Timing timing) {
            this.pipelineOutput = pipelineOutput;
            this.timing = timing;
        }

        @Override
        public void export(Exporter exporter) {
            if (this.pipelineOutput instanceof Exportable) {
                exporter.export(this);
            }
        }
    }
}

