/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines;

import cz.cvut.fel.ida.pipelines.Block;
import cz.cvut.fel.ida.pipelines.ConnectAfter;
import cz.cvut.fel.ida.pipelines.ConnectBefore;
import cz.cvut.fel.ida.pipelines.Pipeline;
import cz.cvut.fel.ida.pipelines.pipes.generic.IdentityGenPipe;
import cz.cvut.fel.ida.utils.generic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class Branch<I, O1, O2>
extends Block
implements ConnectBefore<I> {
    private static final Logger LOG = Logger.getLogger(Branch.class.getName());
    public ConnectAfter<I> input;
    public IdentityGenPipe<O1> output1;
    public IdentityGenPipe<O2> output2;
    Pair<O1, O2> outputReady;

    public Branch(String id) {
        this.ID = id;
        this.output1 = new IdentityGenPipe(id + "Output1");
        this.output2 = new IdentityGenPipe(id + "Output2");
    }

    @Override
    public void accept(I outputFromInputPipe) throws Exception {
        LOG.finer("Entering: " + this.ID);
        this.outputReady = this.branch(outputFromInputPipe);
        this.output1.accept(this.outputReady.r);
        this.output2.accept(this.outputReady.s);
    }

    protected abstract Pair<O1, O2> branch(I var1);

    @Override
    public ConnectAfter<I> getInput() {
        return this.input;
    }

    @Override
    public void setInput(ConnectAfter<I> prev) {
        this.input = prev;
    }

    public ConnectBefore<O1> connectAfterL(ConnectBefore<O1> next) {
        return this.output1.connectAfter(next);
    }

    public <X> Pipeline<O1, X> connectAfterL(Pipeline<O1, X> next) {
        return this.output1.connectAfter(next);
    }

    public ConnectBefore<O2> connectAfterR(ConnectBefore<O2> next) {
        return this.output2.connectAfter(next);
    }

    public <X> Pipeline<O2, X> connectAfterR(Pipeline<O2, X> next) {
        return this.output2.connectAfter(next);
    }

    public List<Branch<I, O1, O2>> parallel(int count) {
        ArrayList<Branch<I, O1, O2>> copies = new ArrayList<Branch<I, O1, O2>>(count);
        for (int i = 0; i < count; ++i) {
            copies.add(new Branch<I, O1, O2>(this.ID + i){

                @Override
                protected Pair<O1, O2> branch(I i1) {
                    return Branch.this.branch(i1);
                }
            });
        }
        return copies;
    }

    public static <T, A extends Branch<?, T, ?>, B extends ConnectBefore<T>> void connectAfterL(List<A> branches, List<B> next) {
        if (branches.size() != next.size()) {
            LOG.severe("The 2 Lists of branches and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < branches.size(); ++i) {
            ((Branch)branches.get(i)).connectAfterL((ConnectBefore)next.get(i));
        }
    }

    public static <T, A extends Branch<?, ?, T>, B extends ConnectBefore<T>> void connectAfterR(List<A> branches, List<B> next) {
        if (branches.size() != next.size()) {
            LOG.severe("The 2 Lists of branches and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < branches.size(); ++i) {
            ((Branch)branches.get(i)).connectAfterR((ConnectBefore)next.get(i));
        }
    }

    public static <T> void connectBefore(List<Branch<T, ?, ?>> branches, List<ConnectAfter<T>> next) {
        if (branches.size() != next.size()) {
            LOG.severe("The 2 Lists of branches and pipes provided cannot be connected with different sizes!");
        }
        for (int i = 0; i < branches.size(); ++i) {
            branches.get(i).connectBefore(next.get(i));
        }
    }
}

