/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines;

import cz.cvut.fel.ida.pipelines.Block;
import cz.cvut.fel.ida.pipelines.ConnectAfter;
import cz.cvut.fel.ida.pipelines.ConnectBefore;
import cz.cvut.fel.ida.pipelines.pipes.generic.IdentityGenPipe;
import cz.cvut.fel.ida.setup.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public abstract class MultiBranch<I, O>
extends Block
implements ConnectBefore<I> {
    private static final Logger LOG = Logger.getLogger(MultiBranch.class.getName());
    public ConnectAfter<I> input;
    public List<IdentityGenPipe<O>> outputs;
    List<O> outputReady;
    boolean parallelBranching = false;

    protected MultiBranch(String id, int count, Settings settings) {
        this.ID = id;
        this.settings = settings;
        this.outputs = new ArrayList<IdentityGenPipe<O>>(count);
        for (int i = 0; i < count; ++i) {
            this.outputs.add(new IdentityGenPipe(id + "Output" + i));
        }
    }

    @Override
    public void accept(I outputFromInputPipe) throws Exception {
        LOG.finer("Entering: " + this.ID);
        this.outputReady = this.branch(outputFromInputPipe);
        if (this.outputs.size() != this.outputReady.size()) {
            LOG.severe("MultiBranch output dimension mismatches with subsequent consumers!");
        }
        if (!this.parallelBranching) {
            for (int i = 0; i < this.outputs.size(); ++i) {
                this.outputs.get(i).accept(this.outputReady.get(i));
            }
        }
    }

    protected abstract List<O> branch(I var1);

    @Override
    public ConnectAfter<I> getInput() {
        return this.input;
    }

    @Override
    public void setInput(ConnectAfter<I> prev) {
        this.input = prev;
    }

    public <T extends ConnectBefore<O>> List<T> connectAfter(List<T> next) {
        if (next.size() != this.outputs.size()) {
            LOG.severe("MultiBranch output dimension mismatches with subsequent consumers!");
        }
        for (int i = 0; i < this.outputs.size(); ++i) {
            this.outputs.get(i).connectAfter((ConnectBefore)next.get(i));
        }
        return next;
    }
}

