/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.debugging.drawing;

import cz.cvut.fel.ida.drawing.Drawer;
import cz.cvut.fel.ida.drawing.GraphViz;
import cz.cvut.fel.ida.logic.Literal;
import cz.cvut.fel.ida.logic.constructs.example.ValuedFact;
import cz.cvut.fel.ida.logic.constructs.template.Template;
import cz.cvut.fel.ida.logic.constructs.template.components.BodyAtom;
import cz.cvut.fel.ida.logic.constructs.template.components.WeightedRule;
import cz.cvut.fel.ida.logic.constructs.template.types.GraphTemplate;
import cz.cvut.fel.ida.setup.Settings;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TemplateDrawer
extends Drawer<Template> {
    public TemplateDrawer(Settings settings) {
        super(settings);
    }

    @Override
    public void loadGraph(Template obj) {
        this.graphviz.start_graph();
        if (obj instanceof GraphTemplate) {
            this.loadGraph((GraphTemplate)obj);
        } else {
            this.loadGraph(new GraphTemplate(obj));
        }
        this.graphviz.end_graph();
    }

    @Override
    public void loadGraph(GraphTemplate obj) {
        Map<Literal, Set<WeightedRule>> atom2rules = obj.atom2rules;
        LinkedHashSet facts = obj.facts;
        for (ValuedFact valuedFact : facts) {
            this.graphviz.addln(this.draw(valuedFact));
        }
        for (Map.Entry entry : atom2rules.entrySet()) {
            Literal literal = (Literal)entry.getKey();
            Set rules = (Set)entry.getValue();
            this.graphviz.addln(this.draw(literal));
            for (WeightedRule rule : rules) {
                this.graphviz.addln(this.draw(rule));
                this.graphviz.addln(this.draw(literal, rule));
                for (BodyAtom bodyAtom : rule.getBody()) {
                    this.graphviz.addln(this.draw(bodyAtom));
                    this.graphviz.addln(this.draw(rule, bodyAtom));
                }
            }
        }
    }

    private String draw(WeightedRule rule, BodyAtom bodyAtom) {
        String edgeColor = bodyAtom.isNegated() ? "red" : "black";
        String weight = bodyAtom.getConjunctWeight() == null ? "" : bodyAtom.getConjunctWeight().toString();
        return rule.hashCode() + " -> " + bodyAtom.hashCode() + "[label=" + GraphViz.sanitize(weight) + ", color=" + edgeColor + "]";
    }

    private String draw(BodyAtom bodyAtom) {
        return this.draw(bodyAtom.literal);
    }

    private String draw(Literal literal, WeightedRule rule) {
        return literal.hashCode() + " -> " + rule.hashCode() + "[label=" + GraphViz.sanitize(rule.getWeight().toString()) + "]";
    }

    private String draw(Literal literal) {
        return literal.hashCode() + "[label=" + GraphViz.sanitize(literal.toString()) + "]";
    }

    private String draw(WeightedRule rule) {
        return rule.hashCode() + "[label=" + GraphViz.sanitize(rule.getOriginalString()) + ", shape=rarrow, color=green]";
    }

    private String draw(ValuedFact fact) {
        return fact.hashCode() + "[label=" + GraphViz.sanitize(fact.toString()) + "]";
    }
}

