/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.pipelines.pipes.specific;

import cz.cvut.fel.ida.neural.networks.structure.building.NeuralProcessingSample;
import cz.cvut.fel.ida.neural.networks.structure.components.NeuralNetwork;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.QueryNeuron;
import cz.cvut.fel.ida.neural.networks.structure.components.neurons.states.State;
import cz.cvut.fel.ida.neural.networks.structure.components.types.DetailedNetwork;
import cz.cvut.fel.ida.neural.networks.structure.transforming.NetworkReducing;
import cz.cvut.fel.ida.pipelines.Pipe;
import cz.cvut.fel.ida.setup.Settings;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class CompressionPipe
extends Pipe<Stream<NeuralProcessingSample>, Stream<NeuralProcessingSample>> {
    private static final Logger LOG = Logger.getLogger(CompressionPipe.class.getName());
    NetworkReducing compressor;

    public CompressionPipe(Settings settings) {
        super("CompressionPipe", settings);
        this.compressor = NetworkReducing.getCompressor(settings);
    }

    @Override
    public Stream<NeuralProcessingSample> apply(Stream<NeuralProcessingSample> neuralProcessingSampleStream) {
        if (this.settings.groundingMode == Settings.GroundingMode.GLOBAL) {
            List<NeuralProcessingSample> neuralProcessingSamples = Utilities.terminateSampleStream(neuralProcessingSampleStream);
            DetailedNetwork detailedNetwork = neuralProcessingSamples.get((int)0).detailedNetwork;
            List<QueryNeuron> queryNeurons = Utilities.terminateSampleStream(neuralProcessingSamples.stream().map(s -> (QueryNeuron)s.query));
            NeuralNetwork reducedNetwork = this.compressor.reduce((DetailedNetwork<State.Structure>)detailedNetwork, queryNeurons);
            this.trueExport();
            return neuralProcessingSamples.stream().map(s -> {
                ((QueryNeuron)s.query).evidence = reducedNetwork;
                return s;
            });
        }
        if (this.exporter != null) {
            neuralProcessingSampleStream.onClose(() -> this.trueExport());
        }
        return neuralProcessingSampleStream.map(sample -> {
            if (!sample.detailedNetwork.compressed) {
                ((QueryNeuron)sample.query).evidence = this.compressor.reduce((DetailedNetwork<State.Structure>)sample.detailedNetwork, (QueryNeuron)sample.query);
                sample.detailedNetwork.compressed = true;
            }
            return sample;
        });
    }

    @Override
    protected <T> void export(T outputReady) {
    }

    protected void trueExport() {
        LOG.info("Compression stats export");
        if (this.exporter != null) {
            this.compressor.finish();
            this.exporter.export(this.compressor);
        }
    }
}

