/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.generic;

import cz.cvut.fel.ida.utils.exporting.Exportable;
import cz.cvut.fel.ida.utils.generic.Utilities;
import java.time.Duration;
import java.time.Instant;
import java.util.logging.Logger;

public class Timing
implements Exportable {
    private static final Logger LOG = Logger.getLogger(Timing.class.getName());
    private Duration timeTaken;
    transient Instant now;
    String totalTimeTaken;
    double totalMinutes;
    long allocatedMemory;
    static long maxMemory = 0L;

    public Timing() {
        this.setTimeTaken(Duration.ofMillis(0L));
    }

    public void tic() {
        this.now = Instant.now();
    }

    public void toc() {
        Instant later = Instant.now();
        Duration elapsed = Duration.between(this.now, later);
        this.setTimeTaken(this.getTimeTaken().plus(elapsed));
        this.now = later;
    }

    public void checkMemory() {
        Utilities.logMemory();
        this.allocatedMemory = Utilities.allocatedMemory / (long)Utilities.mb;
        if (this.allocatedMemory > maxMemory) {
            maxMemory = this.allocatedMemory;
        }
    }

    public void finish() {
        this.totalMinutes = (double)this.timeTaken.toMillis() / 1000.0 / 60.0;
        this.totalTimeTaken = this.getTimeTaken().toString();
        this.checkMemory();
    }

    public Duration getTimeTaken() {
        return this.timeTaken;
    }

    public void setTimeTaken(Duration timeTaken) {
        this.timeTaken = timeTaken;
    }
}

