/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.collections;

import cz.cvut.fel.ida.utils.math.Sugar;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MultiList<R, S> {
    public static final int ARRAY_LIST = 1;
    public static final int LINKED_LIST = 2;
    private int listType = 1;
    private List<S> emptyList = new ArrayList<S>();
    private ConcurrentHashMap<R, List<S>> map = new ConcurrentHashMap();

    public MultiList() {
    }

    public MultiList(int listType) {
        this.listType = listType;
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public List<S> get(Object key) {
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        return this.emptyList;
    }

    public void put(R key, S ... values) {
        if (!this.map.containsKey(key)) {
            if (this.listType == 1) {
                this.map.put(key, Collections.synchronizedList(new ArrayList()));
            } else if (this.listType == 2) {
                this.map.put(key, Collections.synchronizedList(new LinkedList()));
            }
        }
        List<S> list = this.map.get(key);
        for (S value : values) {
            list.add(value);
        }
    }

    public void putAll(R key, Collection<S> values) {
        if (!this.map.containsKey(key)) {
            if (this.listType == 1) {
                this.map.put(key, new ArrayList());
            } else if (this.listType == 2) {
                this.map.put(key, new LinkedList());
            }
        }
        this.map.get(key).addAll(values);
    }

    public void set(R key, List<S> value) {
        this.map.remove(key);
        this.map.put(key, value);
    }

    public void set(R key, Collection<S> value) {
        this.map.remove(key);
        this.map.put(key, Collections.synchronizedList(Sugar.listFromCollections(value)));
    }

    public void remove(Object key, Object value) {
        this.map.get(key).remove(value);
    }

    public void remove(Object key) {
        this.map.remove(key);
    }

    public void clear() {
        this.map.clear();
    }

    public Set<R> keySet() {
        return this.map.keySet();
    }

    public Collection<List<S>> values() {
        return this.map.values();
    }

    public Set<Map.Entry<R, List<S>>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return this.map.toString();
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof MultiList) {
            return this.map.equals(((MultiList)o).map);
        }
        return false;
    }

    public String sizesToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HashListBag[");
        int index = 0;
        for (Map.Entry<R, List<S>> entry : this.map.entrySet()) {
            sb.append(entry.getKey()).append(" ~ ").append(entry.getValue().size());
            if (index++ >= this.map.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public int[] sizes() {
        int[] sizes = new int[this.map.size()];
        int i = 0;
        for (Map.Entry<R, List<S>> entry : this.map.entrySet()) {
            sizes[i] = entry.getValue().size();
            ++i;
        }
        return sizes;
    }

    public MultiList<R, S> copy() {
        MultiList<R, S> retVal = new MultiList<R, S>();
        super.putAll_forCopy(this);
        return retVal;
    }

    private void putAll_forCopy(MultiList<R, S> bag) {
        for (Map.Entry<R, List<S>> entry : bag.entrySet()) {
            this.putAll(entry.getKey(), Sugar.listFromCollections(entry.getValue()));
        }
    }
}

