/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.ida.utils.math.random;

import cz.cvut.fel.ida.utils.math.VectorUtils;
import java.util.Random;

public class CustomRandomGenerator {
    private double[] cummulated;
    private Random random = new Random();

    public CustomRandomGenerator(int[] histogram) {
        double sum = VectorUtils.sum(histogram);
        double cumm = 0.0;
        this.cummulated = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            this.cummulated[i] = cumm += (double)histogram[i] / sum;
        }
    }

    public CustomRandomGenerator(double[] histogram) {
        double sum = VectorUtils.sum(histogram);
        double cumm = 0.0;
        this.cummulated = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            this.cummulated[i] = cumm += histogram[i] / sum;
        }
    }

    public CustomRandomGenerator(int[] histogram, Random random) {
        this(histogram);
        this.random = random;
    }

    public CustomRandomGenerator(double[] histogram, Random random) {
        this(histogram);
        this.random = random;
    }

    public int nextInt() {
        if (this.cummulated.length == 1) {
            return 0;
        }
        double rand = this.random.nextDouble();
        int start = 0;
        int end = this.cummulated.length - 1;
        int s = (start + end) / 2;
        do {
            if (this.cummulated[s] > rand && (s == 0 || this.cummulated[s - 1] < rand) || s == this.cummulated.length - 1) {
                return s;
            }
            if (this.cummulated[s] < rand) {
                start = s + 1;
            } else if (this.cummulated[s] > rand) {
                end = s - 1;
            }
            s = (start + end) / 2;
        } while (start <= end);
        throw new RuntimeException("An error occured iterable method nextInt()");
    }
}

