#!/bin/bash

echo starting job...
source ~/.bashrc
conda activate ww_train
export PYTHONUNBUFFERED=1
export OMP_NUM_THREADS=1

root=$(pwd)
data_root=$(pwd)/data
ckpt_root=$(pwd)/checkpoints

cd ${root}/src

for SLURM_ARRAY_TASK_ID in {2..21..1}
    do 
        cfg=$(sed -n "$SLURM_ARRAY_TASK_ID"p ${root}/src/scripts/txt_file/imagenet_snr.txt)

        netType=$(echo $cfg | cut -f 1 -d ' ')
        width=$(echo $cfg | cut -f 2 -d ' ')
        depth=$(echo $cfg | cut -f 3 -d ' ')
        dataset=$(echo $cfg | cut -f 4 -d ' ')
        num_epochs=$(echo $cfg | cut -f 5 -d ' ')
        lr_sche=$(echo $cfg | cut -f 6 -d ' ')
        seed=$(echo $cfg | cut -f 7 -d ' ')
        lr=$(echo $cfg | cut -f 8 -d ' ')
        weight_decay=$(echo $cfg | cut -f 9 -d ' ')
        warmup_epochs=$(echo $cfg | cut -f 10 -d ' ')
        fix_fingers=$(echo $cfg | cut -f 11 -d ' ')
        remove_first=$(echo $cfg | cut -f 12 -d ' ')
        remove_last=$(echo $cfg | cut -f 13 -d ' ')
        metric=$(echo $cfg | cut -f 14 -d ' ')
        temp_balance_lr=$(echo $cfg | cut -f 15 -d ' ')
        batchnorm=$(echo $cfg | cut -f 16 -d ' ')
        lr_min_ratio=$(echo $cfg | cut -f 17 -d ' ')
        lr_slope=$(echo $cfg | cut -f 18 -d ' ')
        xmin_pos=$(echo $cfg | cut -f 19 -d ' ')
        sg=$(echo $cfg | cut -f 20 -d ' ')
        stage_epoch=$(echo $cfg | cut -f 21 -d ' ')
        lr_min_ratio2=$(echo $cfg | cut -f 22 -d ' ')

        base_path=${ckpt_root}/${netType}/${metric}_fixf${fix_fingers}_xminpos${xmin_pos}_snr_baseline
        base_path=${base_path}/sg${sg}_stage${stage_epoch}

        ckpt_folder=${netType}_${depth}_${width}_${dataset}_${lr}_${lr_sche}_${num_epochs}_wd${weight_decay}_seed${seed}_warm${warmup_epochs}
        mkdir -p ${base_path}/${ckpt_folder}
        wandb_tag=${ckpt_folder}_${metric}_fixf${fix_fingers}_xminpos${xmin_pos}_snr_baseline_sg${sg}_stage${stage_epoch}

        CUDA_VISIBLE_DEVICES=0 python imagenet_main_snr.py \
            --lr ${lr} \
            --net-type ${netType} \
            --depth ${depth} \
            --num-epochs ${num_epochs} \
            --widen-factor ${width} \
            --warmup-epochs ${warmup_epochs} \
            --seed ${seed} \
            --wandb-on False \
            --print-tofile False \
            --dataset ${dataset} \
            --lr-sche ${lr_sche} \
            --datadir ${data_root} \
            --weight-decay ${weight_decay} \
            --wandb-tag ${wandb_tag} \
            --fix-fingers ${fix_fingers} \
            --remove-last-layer ${remove_last} \
            --remove-first-layer ${remove_first} \
            --metric ${metric} \
            --temp-balance-lr ${temp_balance_lr} \
            --batchnorm ${batchnorm} \
            --lr-min-ratio ${lr_min_ratio} \
            --lr-slope ${lr_slope} \
            --xmin-pos ${xmin_pos} \
            --lr-min-ratio-stage2 ${lr_min_ratio2} \
            --sg ${sg} \
            --stage-epoch ${stage_epoch} \
            --ckpt-path ${base_path}/${ckpt_folder} 

    done