# Unleashing the Power of Transformer for Graphs

The code currently has different dependencies for different tasks. We plan to develop a unified framework based on PyTorch Geometric later.

Here, we show an example how to run it on node classification task. 

### Installation

```bash
CUDA=${1:-"cu101"} # assume the cuda version is 10.1
conda create -n DET python=3.7
conda activate DET
conda install torch==1.4.0 cudatoolkit==10.1
pip install torch-scatter==2.0.4 -f https://pytorch-geometric.com/whl/torch-1.4.0+${CUDA}.html
pip install torch-sparse==0.6.1 -f https://pytorch-geometric.com/whl/torch-1.4.0+${CUDA}.html
pip install torch-cluster==1.5.4 -f https://pytorch-geometric.com/whl/torch-1.4.0+${CUDA}.html
pip install torch-spline-conv==1.2.0 -f https://pytorch-geometric.com/whl/torch-1.4.0+${CUDA}.html
pip install torch-geometric==1.4.3
pip install -r requirements.txt
```

### Run

Enter the following scripts in bash:

```bash
conda activate DET 
python3 DET/main.py \
    --dataset-class Planetoid \
    --dataset-name Cora \
    --custom-key EV13NSO8-ES \
    --attention-type dot_product \
    --tau 0.15 \
    --is-dual-encoding True \
    --num-gpus-total 1
```

which will output the results on Cora dataset.


### Thanks

The code is mainly adapted from the existing git repositories: 

graph property prediction: [Graphormer](https://github.com/microsoft/Graphormer)

node classificaiton: [Pytorch Graph Attention Network](https://github.com/Diego999/pyGAT)

KG completion: [HittER](https://github.com/microsoft/HittER)

Many thanks to the authors!