from abc import ABC, abstractmethod

from transformers import EvalPrediction


class Metric(ABC):
    def compute(self, eval_preds: EvalPrediction, compute_result: bool = False) -> dict:
        return self._compute(eval_preds, compute_result=compute_result)

    @abstractmethod
    def _compute(self, eval_preds: EvalPrediction, compute_result: bool = False) -> dict:
        pass
