from abc import ABC, abstractmethod
from typing import Any

from pydantic import BaseModel

from src.utils.logging_utils import get_logger

logger = get_logger(name=__name__)


class PipelineStep(ABC):
    class Config(BaseModel):
        pass

    def __init__(self, **kwargs) -> None:
        self.config = self.Config(**kwargs)

    def __call__(self, **kwargs) -> Any:
        logger.info(f"Running {self.__class__.__name__}")
        ret_value = self._call(**kwargs)
        logger.info(f"Done running {self.__class__.__name__}")
        return ret_value

    @abstractmethod
    def _call(self, **kwargs) -> Any:
        pass
