from typing import Dict


def stats_for_admission_concept(binary_indicator: bool, admission_codes: Dict, prefix: str):
    if binary_indicator:
        max_visit_pcs_num = max([len(codes) for codes in admission_codes.values()])
        nan_visit_pcs_num = sum([1 for codes in admission_codes.values() if len(codes) == 0])
        n_admission, n_admission_pcs = len(admission_codes), sum([len(codes) for codes in admission_codes.values()])
        gross_avg_visit_pcs_num = n_admission_pcs / n_admission
        net_avg_visit_pcs_num = n_admission_pcs / (n_admission - nan_visit_pcs_num)
        print('Summarizing %s codes ...' % prefix)
        print('\t max concept num in an admission %d' % max_visit_pcs_num)
        print('\t nan / total concept num in an admission %d / %d' % (nan_visit_pcs_num, n_admission))
        print('\t gross mean concept num in an admission %.2f' % gross_avg_visit_pcs_num)
        print('\t net mean concept num in an admission %.2f' % net_avg_visit_pcs_num)
