import sys
from .custom_encoders import *
from .lpg_dataset import LPGDataset


class MAKGDataset(LPGDataset):
    node_encoding_functions = {
        "labels": (lambda vertices: category_encoding(vertices, "labels")),
        "entityid": (lambda vertices: integer_encoding(vertices, "entityid")),
        "rank": (lambda vertices: integer_encoding(vertices, "rank")),
        "name": (lambda vertices: text_encoding_onehot(
            vertices, "name", keep_most_frequent=100)),
        "papercount":
        (lambda vertices: integer_encoding(vertices, "papercount")),
        "citationcount":
        (lambda vertices: integer_encoding(vertices, "citationcount")),
        "created": (lambda vertices: date_encoding(vertices, "created")),
        "homepage": (lambda vertices: text_encoding_onehot(
            vertices, "homepage", keep_most_frequent=100)),
        "location": (lambda vertices: category_encoding(vertices, "location")),
        "startdate": (lambda vertices: date_encoding(vertices, "created")),
        "enddate": (lambda vertices: date_encoding(vertices, "enddate")),
        "submissiondeadlinedate":
        (lambda vertices: date_encoding(vertices, "submissiondeadlinedate")),
        "notificationduedate":
        (lambda vertices: date_encoding(vertices, "notificationduedate")),
        "finalversionduedate":
        (lambda vertices: date_encoding(vertices, "finalversionduedate")),
        "abstractregistrationdate":
        (lambda vertices: date_encoding(vertices, "abstractregistrationdate")),
        "issn": (lambda vertices: category_encoding(vertices, "issn")),
        "publisher":
        (lambda vertices: category_encoding(vertices, "publisher")),
        "title": (lambda vertices: text_encoding_onehot(
            vertices, "title", keep_most_frequent=100)),
        "publicationdate":
        (lambda vertices: date_encoding(vertices, "publicationdate")),
        "referencecount":
        (lambda vertices: integer_encoding(vertices, "referencecount")),
        "estimatedcitationcount":
        (lambda vertices: integer_encoding(vertices, "estimatedcitationcount")
         ),
        "volume": (lambda vertices: integer_encoding(vertices, "volume")),
        "issueidentifier":
        (lambda vertices: integer_encoding(vertices, "issueidentifier")),
        "startingpage":
        (lambda vertices: integer_encoding(vertices, "startingpage")),
        "doi": (lambda vertices: category_encoding(vertices, "doi")),
        "endingpage":
        (lambda vertices: integer_encoding(vertices, "endingpage")),
        "booktitle": (lambda vertices: text_encoding_onehot(
            vertices, "booktitle", keep_most_frequent=100)),
        "grid": (lambda vertices: category_encoding(vertices, "grid")),
        "seealso": (lambda vertices: category_encoding(vertices, "seealso")),
        "sameas": (lambda vertices: category_encoding(vertices, "sameas")),
        "field": (lambda vertices: category_encoding(vertices, "field")),
    }
    edge_encoding_functions = {
        "type": (lambda edges: category_encoding(edges, "type"))
    }

    @property
    def raw_file_names(self):
        return ['makg_vertices.csv', 'makg_edges.csv']

    def download(self):
        print(self.raw_dir)
        print("ERROR: MAKG dataset is not present in raw folder")
        sys.exit()
