from torch_geometric.graphgym.register import register_config


@register_config('ignore_index')
def set_cfg_ignore_index(cfg):
    r'''
    This function sets the default config value for customized options
    :return: customized configuration use by the experiment.
    '''

    # ----------------------------------------------------------------------- #
    # Customized options
    # ----------------------------------------------------------------------- #

    # ignore_index to be applied cross_entropy or mse loss if
    # cfg.model.loss_fun == 'cross_entropy_with_ignore_index' or
    # cfg.model.loss_fun == 'mse_with_ignore_index' or
    # cfg.dataset.task_type == 'classification_binary_with_ignore_index' or
    # cfg.dataset.task_type == 'classification_multi_with_ignore_index' or
    # cfg.dataset.task_type == 'classification_multilabel_with_ignore_index' or
    # cfg.dataset.task_type == 'regression_with_ignore_index'
    cfg.dataset.ignore_index = None
