from torch_geometric.graphgym.register import register_config


@register_config('node_edge_feature')
def set_cfg_node_edge_feature(cfg):
    r'''
    This function sets the default config value for customized options
    :return: customized configuration use by the experiment.
    '''

    # ----------------------------------------------------------------------- #
    # Customized options
    # ----------------------------------------------------------------------- #

    # names of labels/properties to be added to node feature vectors
    cfg.dataset.node_features = 'none'

    # name of the prediction target of a node feature used when cfg.dataset.task == 'node'
    cfg.dataset.node_prediction_target = 'none'

    # names of labels/properties to be added to edge feature vectors
    cfg.dataset.edge_features = 'type'

    # name of the prediction target of an edge feature used when cfg.dataset.task == 'edge'
    cfg.dataset.edge_prediction_target = 'none'
