#!/bin/bash
dataset_target='superglue-wic'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
attn_method='weight'
self_train_source_dir="./outputs/self_training/self_fs_s_mnli_t_${dataset_target}"

export CUDA_VISIBLE_DEVICES='1'
save_dir="./outputs/self_training/attn_6_${dataset_target}"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --ignore_target \
  --self_train_attn \
  --self_train_source_dir $self_train_source_dir \
  > ${save_dir}/debug.log 2>&1 &