#!/bin/bash
dataset_target='superglue-rte'
json_file="./attempt/configs/fewshot/target_${dataset_target}.json"
fewshot_num=20
fewshot_num_begin=0
attn_method='sub'
# full or few-shot
eval_dataset_type='full'
prompt_embedding_path_prefix="/export/home/OpenPrompt/mixture_prompt/source_prompts"
model_name='t5-base'
per_device_train_batch_size=32
per_device_eval_batch_size=32

export CUDA_VISIBLE_DEVICES='3'
save_dir="./outputs/baselines/attempt_wo_target/${model_name}/${dataset_target}_sd_${fewshot_num_begin}"
mkdir -p $save_dir
#   --data_full \

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --fewshot \
  --fewshot_num $fewshot_num \
  --attn_method $attn_method \
  --save_dir $save_dir \
  --eval_dataset_type $eval_dataset_type \
  --fewshot_num_begin $fewshot_num_begin \
  --update_path_original \
  --prompt_embedding_path_prefix $prompt_embedding_path_prefix \
  --model_name $model_name \
  --per_device_eval_batch_size $per_device_eval_batch_size \
  --per_device_train_batch_size $per_device_train_batch_size \
  --ignore_target \
  > ${save_dir}/debug.log 2>&1 &