#!/bin/bash
# 1. For each soure task we need to fine-tune on 32 samples. Few shot then get label.

# save datasets in the folder > pseudo_label_dataset.pickle

# target dataset
dataset_target='superglue-cb'

#self_train_source_dir="./outputs/self_training/train_loss_entire_${dataset_target}"
self_train_source_dir="./outputs/vote_attn/uw_attn_decode_ft_${dataset_target}_100_100_hloss_500_neutral_st"

export CUDA_VISIBLE_DEVICES='2'
#1.1 mnli: source datasets
dataset='mnli'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &

export CUDA_VISIBLE_DEVICES='3'
#1.2 qnli source datasets
dataset='qnli'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &

export CUDA_VISIBLE_DEVICES='4'
#1.3 qqp source datasets
dataset='qqp'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &


export CUDA_VISIBLE_DEVICES='5'
#1.4 sst2 source datasets
dataset='sst2'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &

export CUDA_VISIBLE_DEVICES='6'
#1.5 squad: source datasets
dataset='squad'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &

export CUDA_VISIBLE_DEVICES='7'
#1.6 record: source datasets
dataset='record'
json_file="./attempt/configs/self_training/source_${dataset}.json"
save_dir="./outputs/vote_attn_teachers/self_fs_s_${dataset}_t_${dataset_target}_st_attn"
mkdir -p $save_dir

nohup python \
  attempt/seq2seq/few_shot.py \
  --json_file $json_file \
  --dataset_target $dataset_target \
  --save_dir $save_dir \
  --perplexity_calc \
  --self_train_source_dir $self_train_source_dir \
  --self_train_attn \
  > ${save_dir}/debug.log 2>&1 &
